/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.util;

import de.maggicraft.mcommons.util.EOSType;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.IDataDrop;
import de.maggicraft.mgui.view.MPanel;
import de.maggicraft.mgui.view.util.IView;
import de.maggicraft.mlog.MLog;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public final class Util {
    @NotNull
    private static final HashMap<Font, FontMetrics> FONT_METRICS = new HashMap();
    private static final JTextArea AREA_METRICS = new JTextArea();
    private static final String WINDOWS_10 = "windows 10";
    private static int sBorderWidth;
    private static int sBorderHeight;
    private static int sBorderDialogWidth;
    private static int sBorderDialogHeight;

    private Util() {
    }

    public static void registerLookFeel(@NotNull JComponent pComp) {
        LookAndFeel old = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception pE) {
            old = null;
            MLog.log(pE);
        }
        pComp.updateUI();
        if (old != null) {
            try {
                UIManager.setLookAndFeel(old);
            }
            catch (UnsupportedLookAndFeelException pE) {
                MLog.log(pE);
            }
        }
    }

    public static void highlightText(@NotNull JTextComponent pComp, @NotNull String pText) {
        Util.highlightText(pComp, pText, false);
    }

    public static void highlightText(@NotNull JTextComponent pComp, @NotNull String pText, boolean pCaseSensitive) {
        if (pText.isEmpty()) {
            return;
        }
        String text = pComp.getText();
        if (!pCaseSensitive) {
            text = text.toLowerCase();
            pText = pText.toLowerCase();
        }
        LinkedList<Integer> list = new LinkedList<Integer>();
        int curIndex = 0;
        while ((curIndex = text.indexOf(pText, curIndex)) != -1) {
            list.add(curIndex);
            curIndex += pText.length();
        }
        try {
            for (Integer index : list) {
                pComp.getHighlighter().addHighlight(index, index + pText.length(), MCon.textHighlighter());
            }
        }
        catch (BadLocationException pE) {
            MLog.log(pE);
        }
    }

    public static void removeHighlight(@NotNull JTextComponent pComp) {
        pComp.getHighlighter().removeAllHighlights();
    }

    public static void addScrollDepthEvent(final @NotNull IView pView, final @NotNull Runnable pRunnable, int pHeight, float pPercentage) {
        int abs = (int)((float)pHeight * pPercentage) - 8;
        new MPanel(MPos.pos("[[<>1<>,[[<" + abs + ">1<>", pView)){
            final boolean mPainted = false;
            {
                super(pPos);
                this.mPainted = false;
            }

            @Override
            protected void paintComponent(Graphics pGraphic) {
                pRunnable.run();
                pView.remove(this);
            }
        };
    }

    public static int addWidth(Font pFont, String ... pText) {
        return Util.addWidth(Util.getMetrics(pFont), pText);
    }

    public static int addWidth(@NotNull FontMetrics pMetrics, String ... pText) {
        int width = 0;
        for (String aText : pText) {
            width += pMetrics.stringWidth(aText);
        }
        return width;
    }

    public static FontMetrics getMetrics(Font pFont) {
        return FONT_METRICS.computeIfAbsent(pFont, AREA_METRICS::getFontMetrics);
    }

    public static int getWidth(Font pFont, String[] ... pText) {
        FontMetrics metrics = Util.getMetrics(pFont);
        int minWidth = 0;
        for (String[] text : pText) {
            int width = Util.getWidth(metrics, text);
            if (width <= minWidth) continue;
            minWidth = width;
        }
        return minWidth + 1;
    }

    public static int getWidth(@NotNull FontMetrics pMetrics, String ... pText) {
        int minWidth = 0;
        for (String text : pText) {
            int width = pMetrics.stringWidth(text);
            if (width <= minWidth) continue;
            minWidth = width;
        }
        return minWidth + 1;
    }

    public static int getWidth(String ... text) {
        return Util.getWidth(MCon.fontText(), text);
    }

    public static int getWidth(Font pFont, String ... pText) {
        return Util.getWidth(Util.getMetrics(pFont), pText);
    }

    public static void openURL(@NotNull String pURL) {
        if (!(pURL.startsWith("https://") || pURL.startsWith("http://") || pURL.startsWith("file://"))) {
            throw new IllegalArgumentException("not a valid uri: " + pURL);
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(pURL));
            }
        }
        catch (IOException | URISyntaxException pE) {
            MLog.log(pE);
        }
    }

    @NotNull
    public static String removed(@NotNull String pStr, int pOffset, int pLength) {
        String text = pStr.substring(0, pOffset);
        if (pOffset + pLength < pStr.length()) {
            text = text + pStr.substring(pOffset + pLength);
        }
        return text;
    }

    public static void initBorderSize() {
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(100, 100));
        frame.getContentPane().add(panel);
        frame.pack();
        sBorderWidth = (frame.getWidth() - 100) / 2;
        if (System.getProperty("os.name").equalsIgnoreCase(WINDOWS_10)) {
            sBorderWidth -= 2;
        }
        sBorderHeight = frame.getHeight() - 100;
        if (EOSType.getOperatingSystem() == EOSType.OS_WINDOWS) {
            sBorderDialogWidth = sBorderWidth - 10;
            sBorderDialogHeight = sBorderHeight - 10;
        } else {
            sBorderDialogWidth = 1;
            sBorderDialogHeight = 23;
        }
    }

    @NotNull
    public static JFrame getParentFrame(@NotNull JComponent pComp) {
        Container container = pComp.getRootPane().getParent();
        while (!(container instanceof JFrame)) {
            container = container.getParent();
        }
        return (JFrame)container;
    }

    public static void addDataDrop(@NotNull JComponent pComp, final @NotNull IDataDrop pDrop) {
        pComp.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(@NotNull DropTargetDropEvent pEvt) {
                try {
                    pEvt.acceptDrop(1);
                    List droppedFiles = (List)pEvt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    pDrop.drop(droppedFiles);
                }
                catch (Exception pE) {
                    MLog.log(pE);
                }
            }
        });
    }

    public static int getBorderWidth() {
        return sBorderWidth;
    }

    public static int getBorderHeight() {
        return sBorderHeight;
    }

    public static int getBorderDialogWidth() {
        return sBorderDialogWidth;
    }

    public static int getBorderDialogHeight() {
        return sBorderDialogHeight;
    }
}

