/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MBoxLayout
implements LayoutManager {
    private final int mCompWidth;
    private final int mCompHeight;
    private final int mCompGapH;
    private final int mCompGapV;
    private final int mDimX;
    private final int mDimY;

    public MBoxLayout(int pCompWidth, int pCompHeight, int pCompGapH, int pCompGapV) {
        this.mCompWidth = pCompWidth;
        this.mCompHeight = pCompHeight;
        this.mCompGapH = pCompGapH;
        this.mCompGapV = pCompGapV;
        this.mDimX = this.mCompWidth + this.mCompGapH;
        this.mDimY = this.mCompHeight + this.mCompGapV;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        int columns = this.getColumns(parent.getWidth());
        int height = this.getHeight(columns, parent.getComponentCount());
        return new Dimension(parent.getWidth(), height);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container parent) {
        int height = this.getHeight(this.getColumns(parent.getWidth()), parent.getComponentCount());
        return new Dimension(this.mCompWidth, height);
    }

    @Override
    public void layoutContainer(@NotNull Container parent) {
        if (parent.getWidth() == 0) {
            return;
        }
        int comps = parent.getComponentCount();
        int columns = this.getColumns(parent.getWidth());
        int rows = MBoxLayout.getRows(columns, comps);
        int c = 0;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                parent.getComponent(c).setBounds(this.mCompGapH + x * this.mDimX, y * this.mDimY, this.mCompWidth, this.mCompHeight);
                if (++c != comps) continue;
                return;
            }
        }
    }

    @Contract(pure=true)
    private int getHeight(int pColumns, int pComps) {
        return this.mDimY * MBoxLayout.getRows(pColumns, pComps) - this.mCompGapV;
    }

    @Contract(pure=true)
    private static int getRows(int pColumns, int pComps) {
        return (int)Math.ceil((double)pComps / (double)pColumns);
    }

    @Contract(pure=true)
    private int getColumns(int pWidth) {
        int columns = (pWidth - this.mCompGapH) / this.mDimX;
        return Math.max(columns, 1);
    }
}

