/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.view;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.EWindowSize;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MDialog
extends JDialog
implements IView {
    @NotNull
    private List<IComp> mComps = new ArrayList<IComp>();
    private final boolean mIsUpdatable;

    public MDialog(Frame pOwner, @NotNull EWindowSize pWindowSize) {
        this(pOwner, pWindowSize, true);
    }

    public MDialog(Frame pOwner, @NotNull EWindowSize pWindowSize, boolean pModal) {
        this(pOwner, pWindowSize.asDimension(), pModal);
    }

    public MDialog(Frame pOwner, Dimension pDim, boolean pModal) {
        super(pOwner, pModal);
        this.getContentPane().setBackground(MCon.colorFrame());
        this.setIconImages(MCon.windowIcons());
        this.setLayout(null);
        this.setSize(pDim);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MDialog.this.update();
            }
        });
        this.init(this);
        this.mIsUpdatable = true;
        this.update();
        this.afterInit();
        MCompListeners.compInitialized(this);
    }

    protected void beforeInit() {
    }

    public abstract void init(MDialog var1);

    public void afterInit() {
    }

    @NotNull
    public MDialog visible() {
        new Thread(() -> this.setVisible(true)).start();
        return this;
    }

    @NotNull
    public List<IComp> getComps() {
        return this.mComps;
    }

    @Override
    public void updateLang() {
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).updateLang();
        }
    }

    @Override
    public void updateColor() {
        this.getContentPane().setBackground(MCon.colorFrame());
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).updateColor();
        }
    }

    @Override
    public int prefWidth() {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    public int prefHeight() {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MMPos getPos() {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    public void add(IComp pComp) {
        this.mComps.add(pComp);
        this.add((Component)((Object)pComp));
    }

    @Override
    public void removeComps() {
        for (int i = 0; i < this.mComps.size(); ++i) {
            IComp comp = this.mComps.get(i);
            this.remove((Component)((Object)comp));
            comp.deinitialize();
        }
        this.mComps = new ArrayList<IComp>();
    }

    @Override
    public void remove(IComp pComp) {
        this.mComps.remove(pComp);
        pComp.deinitialize();
        this.remove((Component)((Object)pComp));
    }

    @Override
    public void update() {
        for (int i = 0; i < this.mComps.size(); ++i) {
            MMPos pos = this.mComps.get(i).getPos();
            pos.updateComp(0, 0, this.getWidth() - Util.getBorderDialogWidth(), this.getHeight() - Util.getBorderDialogHeight());
        }
    }

    @Override
    @NotNull
    public MDialog title(@NotNull String pTitle) {
        this.setTitle(MLangManager.get("fr." + pTitle));
        this.setName(pTitle);
        return this;
    }

    @Override
    @NotNull
    public MDialog text(@NotNull String pText) {
        this.setTitle(pText);
        return this;
    }

    @Override
    @NotNull
    public MDialog name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public boolean isUpdatable() {
        return this.mIsUpdatable;
    }

    @Override
    @Nullable
    public String getLangKey() {
        return null;
    }
}

