/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.view;

import de.maggicraft.mcommons.lang.MLangManager;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.ICompound;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MWindowManager;
import de.maggicraft.mgui.util.Util;
import de.maggicraft.mgui.view.util.EWindowSize;
import de.maggicraft.mgui.view.util.IView;
import de.maggicraft.mgui.view.util.MWinStore;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;

public abstract class MFrame
extends JFrame
implements IView {
    private final boolean mIsUpdatable;
    @NotNull
    private List<IComp> mComps = new ArrayList<IComp>();
    private String mLangKey;
    private int mWidth;
    private int mHeight;

    public MFrame(@NotNull EWindowSize pWindowSize) {
        this(new MWinStore(4).start(pWindowSize), true);
    }

    public MFrame(final @NotNull MWinStore pWindowStore, boolean pVisible) {
        MWindowManager.add(this);
        pWindowStore.setFrame(this);
        pWindowStore.position();
        MCon.styleFrame(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent pEvent) {
                pWindowStore.savePos();
            }

            @Override
            public void windowClosed(WindowEvent pEvent) {
                pWindowStore.savePos();
            }
        });
        this.init(this);
        this.mIsUpdatable = true;
        if (pVisible) {
            this.setVisible(true);
            if (pWindowStore.is(32)) {
                this.toFront();
            }
        }
        this.afterInit();
        MCompListeners.compInitialized(this);
    }

    public abstract void init(MFrame var1);

    protected void afterInit() {
    }

    @NotNull
    public MFrame exitOnClose() {
        this.setDefaultCloseOperation(3);
        return this;
    }

    @Override
    public void dispose() {
        MWindowManager.removeView(this);
        super.dispose();
    }

    @Override
    public void setBackground(Color pColor) {
        super.setBackground(pColor);
        this.getContentPane().setBackground(pColor);
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null) {
            this.setTitle(MLangManager.get("ti." + this.mLangKey));
        }
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).updateLang();
        }
        this.update();
    }

    @Override
    public void updateColor() {
        this.getContentPane().setBackground(MCon.colorFrame());
        MCon.getSchemeMisc().initComboStyle();
        this.setBackground(MCon.colorFrame());
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).updateColor();
        }
    }

    @Override
    @NotNull
    public MFrame title(@NotNull String pTitle) {
        this.mLangKey = pTitle;
        this.setTitle(MLangManager.get("fr." + pTitle));
        this.setName(pTitle);
        return this;
    }

    @Override
    @NotNull
    public MFrame text(@NotNull String pText) {
        this.setTitle(pText);
        return this;
    }

    @Override
    @NotNull
    public MFrame name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    public void add(IComp pComp) {
        this.mComps.add(pComp);
        this.add((Component)((Object)pComp));
    }

    @Override
    public void removeComps() {
        for (int i = 0; i < this.mComps.size(); ++i) {
            IComp comp = this.mComps.get(i);
            if (comp instanceof IView) {
                ((IView)comp).removeComps();
            }
            if (comp instanceof ICompound) {
                ((ICompound)((Object)comp)).remove();
            }
            this.remove((Component)((Object)comp));
            comp.deinitialize();
        }
        this.mComps = new ArrayList<IComp>();
    }

    @Override
    public void remove(IComp pComp) {
        this.mComps.remove(pComp);
        if (pComp instanceof IView) {
            ((IView)pComp).removeComps();
        }
        if (pComp instanceof ICompound) {
            ((ICompound)((Object)pComp)).remove();
        }
        this.remove((Component)((Object)pComp));
        pComp.deinitialize();
    }

    @Override
    public void update() {
        if (!this.isUpdatable()) {
            return;
        }
        for (int i = 0; i < this.mComps.size(); ++i) {
            MMPos pos = this.mComps.get(i).getPos();
            if (pos == null) continue;
            pos.updateComp(0, 0, this.getWidth() - Util.getBorderWidth(), this.getHeight() - Util.getBorderHeight());
        }
    }

    @Override
    public void setVisible(boolean pVisible) {
        super.setVisible(pVisible);
        if (pVisible) {
            this.update();
        }
    }

    @NotNull
    public List<IComp> getComps() {
        return this.mComps;
    }

    @Override
    public boolean isUpdatable() {
        return this.isVisible() && this.mIsUpdatable;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getWidth() != this.mWidth || this.getHeight() != this.mHeight) {
            this.mWidth = this.getWidth();
            this.mHeight = this.getHeight();
            this.update();
        }
    }

    @Override
    @NotNull
    public MMPos getPos() {
        throw CCon.NOT_SUPPORTED;
    }
}

