/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.view;

import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.ICompound;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MLayered
extends JLayeredPane
implements IView {
    @NotNull
    private ArrayList<IComp> mComps = new ArrayList();
    @NotNull
    private final MMPos mPos;

    public MLayered(@NotNull MMPos pPos) {
        this.setFocusable(false);
        this.setLayout(null);
        this.setOpaque(true);
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    public void add(IComp pComp, int pLayer) {
        this.mComps.add(pComp);
        this.add((Component)((Object)pComp), pLayer);
    }

    @Override
    public void updateColor() {
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).updateColor();
        }
    }

    @Override
    public void updateLang() {
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).updateLang();
        }
    }

    @Override
    @NotNull
    public MLayered title(@NotNull String pTitle) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MLayered text(@NotNull String pText) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MLayered name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    @Nullable
    public String getLangKey() {
        return null;
    }

    @Override
    public void add(IComp pComp) {
        this.mComps.add(pComp);
        this.add((Component)((Object)pComp), 0);
    }

    @Override
    public void removeComps() {
        for (int i = 0; i < this.mComps.size(); ++i) {
            IComp comp = this.mComps.get(i);
            if (comp instanceof IView) {
                ((IView)comp).removeComps();
            }
            if (comp instanceof ICompound) {
                ((ICompound)((Object)comp)).remove();
            }
            this.remove((Component)((Object)comp));
            comp.deinitialize();
        }
        this.mComps = new ArrayList();
    }

    @Override
    public void remove(IComp pComp) {
        this.mComps.remove(pComp);
        if (pComp instanceof IView) {
            ((IView)pComp).removeComps();
        }
        if (pComp instanceof ICompound) {
            ((ICompound)((Object)pComp)).remove();
        }
        this.remove((Component)((Object)pComp));
        pComp.deinitialize();
    }

    @Override
    public void update() {
        if (!this.isUpdatable()) {
            return;
        }
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).getPos().updateComp(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void setVisible(boolean pVisible) {
        super.setVisible(pVisible);
        if (pVisible) {
            this.update();
        }
    }

    @NotNull
    public List<IComp> getComps() {
        return this.mComps;
    }

    @Override
    public boolean isUpdatable() {
        return this.isVisible();
    }

    @Override
    public void setBounds(int pX, int pY, int pWidth, int pHeight) {
        super.setBounds(pX, pY, pWidth, pHeight);
        this.update();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @NotNull
    public static MLayered retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MLayered)MReflection.retrieveComp(pView, pPath, MLayered.class);
    }
}

