/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.view;

import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.ICompound;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.ITippable;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.util.MTip;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MPanel
extends JPanel
implements IView,
ITippable {
    @NotNull
    private List<IComp> mComps = new ArrayList<IComp>();
    private MMPos mPos;
    private MTip mTip;
    private String mLangKey;

    public MPanel(@NotNull MMPos pPos, Color pColor) {
        this(pPos);
        this.setBackground(pColor);
        MCompListeners.compInitialized(this);
    }

    public MPanel(@NotNull MMPos pPos) {
        this.setFocusable(false);
        this.setLayout(null);
        this.setOpaque(true);
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    @Override
    public void updateColor() {
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).updateColor();
        }
    }

    @Override
    public void updateLang() {
        if (this.mLangKey != null && this.mTip != null) {
            this.mTip.updateLang(this, "pa.tt." + this.mLangKey);
        }
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).updateLang();
        }
    }

    @Override
    @NotNull
    public MPanel title(@NotNull String pTitle) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MPanel text(@NotNull String pText) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MPanel name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public String getLangKey() {
        return this.mLangKey;
    }

    @Override
    public void add(IComp pComp) {
        this.mComps.add(pComp);
        this.add((Component)((Object)pComp));
    }

    @Override
    public void removeComps() {
        for (int i = 0; i < this.mComps.size(); ++i) {
            IComp comp = this.mComps.get(i);
            if (comp instanceof IView) {
                ((IView)comp).removeComps();
            }
            if (comp instanceof ICompound) {
                ((ICompound)((Object)comp)).remove();
            }
            this.remove((Component)((Object)comp));
            comp.deinitialize();
        }
        this.mComps = new ArrayList<IComp>();
    }

    @Override
    public void remove(IComp pComp) {
        this.mComps.remove(pComp);
        if (pComp instanceof IView) {
            ((IView)pComp).removeComps();
        }
        if (pComp instanceof ICompound) {
            ((ICompound)((Object)pComp)).remove();
        }
        this.remove((Component)((Object)pComp));
        pComp.deinitialize();
    }

    @Override
    public void update() {
        if (!this.isUpdatable()) {
            return;
        }
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).getPos().updateComp(0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void setVisible(boolean pVisible) {
        super.setVisible(pVisible);
        if (pVisible) {
            this.update();
        }
    }

    @NotNull
    public List<IComp> getComps() {
        return this.mComps;
    }

    @Override
    public boolean isUpdatable() {
        return this.isVisible();
    }

    @Override
    @NotNull
    public MPanel tip(@NotNull MTip pTip) {
        this.mTip = pTip;
        pTip.tip(this);
        return this;
    }

    @Override
    @NotNull
    public MPanel title(@NotNull String pTitle, @NotNull MTip pTip) {
        this.mTip = pTip;
        this.mLangKey = pTitle;
        pTip.tip(this, "pa.tt." + pTitle);
        return this;
    }

    @Override
    @NotNull
    public Point getToolTipLocation(MouseEvent pEvent) {
        return MCon.posToolTip(this);
    }

    @Override
    public MTip getTip() {
        return this.mTip;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.update();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    public void setPos(MMPos pPos) {
        this.mPos = pPos;
        this.mPos.setComp(this);
    }

    @NotNull
    public static MPanel retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MPanel)MReflection.retrieveComp(pView, pPath, MPanel.class);
    }
}

