/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.view;

import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.ICompound;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.view.MView;
import de.maggicraft.mgui.view.util.IView;
import de.maggicraft.mgui.view.util.MScrollPaneStyle;
import de.maggicraft.mlog.MLog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MScroll
extends JScrollPane
implements IView {
    private static final String[] NAMES = new String[]{"Up", "Down", "Left", "Right"};
    private static final int[] KEYS = new int[]{38, 37, 40, 39};
    private static final int SCROLL_INCREMENT = 40;
    private final MMPos mPos;
    private final boolean mIsUpdatable;
    @NotNull
    private ArrayList<MView> mViews = new ArrayList();
    private MView mCurView;
    private boolean mViewActivated = true;
    private boolean mIsMiddleActive;
    private Point mMiddleClicked;
    private Point mMiddleCurrent;

    public MScroll(@NotNull IView pView) {
        this(MPos.pos(pView, "||<>m<>,||<>m<>"), true);
    }

    public MScroll(MMPos pPos) {
        this(pPos, true);
    }

    public MScroll(MMPos pPos, boolean pScrollByKeys) {
        this.mPos = pPos;
        this.mPos.addComp(this);
        MCon.styleScroll(this);
        this.getVerticalScrollBar().setUnitIncrement(40);
        this.getHorizontalScrollBar().setUnitIncrement(40);
        if (pScrollByKeys) {
            this.scrollByKeys();
        }
        this.mIsUpdatable = true;
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public static MScroll single(@NotNull IView pView) {
        return MScroll.single(MPos.pos(pView, "||<>m<>,||<>m<>"), true);
    }

    @NotNull
    public static MScroll single(MMPos pPos) {
        return MScroll.single(pPos, true);
    }

    @NotNull
    public static MScroll single(MMPos pPos, boolean pScrollByKeys) {
        MScroll scroll = new MScroll(pPos, pScrollByKeys);
        scroll.addViews(new MView<Integer>(){

            @Override
            protected void displayState(Integer pState) {
            }

            @Override
            public Integer getDefaultState() {
                return -1;
            }
        });
        scroll.displayView(0);
        return scroll;
    }

    @NotNull
    public static MScroll retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MScroll)MReflection.retrieveComp(pView, pPath, MScroll.class);
    }

    public void addViews(MView ... pViews) {
        this.mViews = new ArrayList<MView>(Arrays.asList(pViews));
        for (MView view : pViews) {
            view.setScroll(this);
        }
    }

    public void displayView(int pViewIndex) {
        this.displayView(this.mViews.get(pViewIndex));
    }

    public void displayView(int pViewIndex, Object pState) {
        this.displayView(this.mViews.get(pViewIndex), pState);
    }

    public void displayView(@NotNull MView pView) {
        this.displayView(pView, pView.getDefaultState());
    }

    public void displayView(@NotNull MView pView, Object pState) {
        if (!pView.equals(this.mCurView)) {
            for (MView view : this.mViews) {
                view.setVisible(view == pView);
            }
            this.mCurView = pView;
            this.setViewportView(pView);
        }
        pView.display(pState);
    }

    @NotNull
    public MScroll scrollByKeys() {
        InputMap inMap = this.getInputMap(2);
        final BoundedRangeModel[] models = new BoundedRangeModel[]{this.getVerticalScrollBar().getModel(), this.getHorizontalScrollBar().getModel()};
        for (int i = 0; i < 4; ++i) {
            inMap.put(KeyStroke.getKeyStroke(KEYS[i], 0), NAMES[i]);
            final int finalI = i;
            this.getActionMap().put(NAMES[i], new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    models[finalI % 2].setValue(finalI % 2 == 0 ? -40 : 40);
                }
            });
        }
        return this;
    }

    @NotNull
    public MScroll scrollByMiddleButton() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent pE) {
                if (SwingUtilities.isMiddleMouseButton(pE)) {
                    MScroll.this.mIsMiddleActive = !MScroll.this.mIsMiddleActive;
                    MScroll.this.verticalScrollBar.isEnabled();
                    boolean verticalNec = MScrollPaneStyle.isVerticalScrollBarNecessary(MScroll.this.getViewport());
                    boolean horizontalNec = MScrollPaneStyle.isHorizontalScrollBarNecessary(MScroll.this.getViewport());
                    if (MScroll.this.mIsMiddleActive && (verticalNec || horizontalNec)) {
                        Cursor cursor = verticalNec && horizontalNec ? MCon.cursorBoth() : (verticalNec ? MCon.cursorVertical() : MCon.cursorHorizontal());
                        MScroll.this.setCursor(cursor);
                        MScroll.this.mMiddleClicked = pE.getPoint();
                        MScroll.this.mMiddleCurrent = MScroll.this.mMiddleClicked;
                        new Thread(() -> {
                            while (MScroll.this.mIsMiddleActive) {
                                int x;
                                int y = ((MScroll)MScroll.this).mMiddleCurrent.y - ((MScroll)MScroll.this).mMiddleClicked.y;
                                if (Math.abs(y) >= 20) {
                                    MScroll.this.verticalScrollBar.setValue(MScroll.this.verticalScrollBar.getValue() + (int)(0.6 * (double)y));
                                }
                                if (Math.abs(x = ((MScroll)MScroll.this).mMiddleCurrent.x - ((MScroll)MScroll.this).mMiddleClicked.x) >= 20) {
                                    MScroll.this.horizontalScrollBar.setValue(MScroll.this.horizontalScrollBar.getValue() + (int)(0.6 * (double)x));
                                }
                                try {
                                    Thread.sleep(25L);
                                }
                                catch (InterruptedException pE1) {
                                    MLog.log(pE1);
                                }
                            }
                        }).start();
                    } else {
                        MScroll.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent pEvent) {
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent pEvent) {
                if (MScroll.this.mIsMiddleActive) {
                    MScroll.this.mMiddleCurrent = pEvent.getPoint();
                }
            }
        });
        return this;
    }

    public void scrollToTop() {
        this.verticalScrollBar.setValue(this.verticalScrollBar.getMinimum());
    }

    public void scrollToLeft() {
        this.horizontalScrollBar.setValue(this.horizontalScrollBar.getMinimum());
    }

    public void scrollToBottom() {
        this.verticalScrollBar.setValue(this.verticalScrollBar.getMaximum());
    }

    public void scrollToRight() {
        this.horizontalScrollBar.setValue(this.horizontalScrollBar.getMaximum());
    }

    public void setViewActivated(boolean pViewActivated) {
        this.mViewActivated = pViewActivated;
    }

    public int attachHeader(int pOffset, int pPosY) {
        int tmp;
        int scrollY = this.mCurView.getY();
        if (scrollY < pOffset && (tmp = -1 * scrollY + pOffset) > pPosY) {
            return tmp;
        }
        return pPosY;
    }

    @NotNull
    public int[] halfHeader(int pOffset, int pInitGap, int pPosY, int pHeight) {
        int newY;
        int scrollY = this.mCurView.getY();
        if (scrollY < pOffset && (newY = -1 * scrollY + pOffset) > pPosY) {
            int newHeight = Math.max(0, pHeight + scrollY + pInitGap - pOffset);
            return new int[]{newY, newHeight};
        }
        return new int[]{pPosY, pHeight};
    }

    public void setPreferred(int pWidth, int pHeight) {
        this.setPreferred(new Dimension(pWidth, pHeight));
    }

    public void setPreferred(Dimension pPreferred) {
        this.setPreferredSize(pPreferred);
        this.mCurView.setPreferredSize(pPreferred);
    }

    public MView getCurView() {
        return this.mCurView;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.update();
    }

    @Override
    public void setViewportView(Component view) {
        this.setViewport(new JViewport(){

            @Override
            public void setViewPosition(Point p) {
                if (MScroll.this.mViewActivated) {
                    super.setViewPosition(p);
                }
            }
        });
        this.getViewport().setView(view);
    }

    @Override
    public void setVisible(boolean pVisible) {
        super.setVisible(pVisible);
        this.mPos.updateView();
    }

    @Override
    public void add(IComp pComp) {
        this.mCurView.add(pComp);
    }

    @Override
    public void removeComps() {
        for (int i = 0; i < this.mViews.size(); ++i) {
            MView view = this.mViews.get(i);
            view.removeComps();
            if (view instanceof ICompound) {
                ((ICompound)((Object)view)).remove();
            }
            view.deinitialize();
        }
        this.mViews = new ArrayList();
    }

    @Override
    public void remove(IComp pComp) {
        if (pComp instanceof MView) {
            ((MView)pComp).removeComps();
            this.mViews.remove(pComp);
            pComp.deinitialize();
        }
    }

    @Override
    public void update() {
        if (this.isUpdatable()) {
            return;
        }
        for (int i = 0; i < this.mViews.size(); ++i) {
            this.mViews.get(i).update();
        }
    }

    @NotNull
    public List<MView> getComps() {
        return this.mViews;
    }

    @Override
    public void updatePrefWidth() {
        for (int i = 0; i < this.mViews.size(); ++i) {
            this.mViews.get(i).prefWidth();
        }
    }

    @Override
    public void updatePrefHeight() {
        for (int i = 0; i < this.mViews.size(); ++i) {
            this.mViews.get(i).prefHeight();
        }
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @Override
    public void updateColor() {
        for (int i = 0; i < this.mViews.size(); ++i) {
            this.mViews.get(i).updateLang();
        }
    }

    @Override
    public void updateLang() {
        for (int i = 0; i < this.mViews.size(); ++i) {
            this.mViews.get(i).updateLang();
        }
    }

    @Override
    @NotNull
    public MScroll title(@NotNull String pTitle) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MScroll text(@NotNull String pText) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MScroll name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public boolean isUpdatable() {
        return this.mIsUpdatable && this.isVisible();
    }

    @Override
    @Nullable
    public String getLangKey() {
        return null;
    }
}

