/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.view;

import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JSplitPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MSplit
extends JSplitPane
implements IView {
    @NotNull
    private final MMPos mPos;

    public MSplit(@NotNull MMPos pPos) {
        MCon.styleSplit(this);
        pPos.addComp(this);
        this.mPos = pPos;
        MCompListeners.compInitialized(this);
    }

    public MSplit(@NotNull MMPos pPos, int pDividerLoc) {
        this(pPos);
        this.setDividerLocation(pDividerLoc);
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public MSplit resizeWeight(double pWeight) {
        this.setResizeWeight(pWeight);
        return this;
    }

    @NotNull
    public MSplit expandWithTouch() {
        this.setOneTouchExpandable(true);
        return this;
    }

    public void addComp(Component pCompNeg, Component pCompPos) {
        this.addComp(pCompNeg, pCompPos, true);
    }

    public void addComp(Component pCompNeg, Component pCompPos, boolean pHorizontal) {
        if (pHorizontal) {
            this.setLeftComponent(pCompNeg);
            this.setRightComponent(pCompPos);
            this.setOrientation(1);
        } else {
            this.setTopComponent(pCompNeg);
            this.setBottomComponent(pCompPos);
            this.setOrientation(0);
        }
    }

    @NotNull
    private IComp[] getActiveComps() {
        IComp[] comps = new IComp[2];
        if (this.getOrientation() == 1) {
            if (this.getLeftComponent() instanceof IComp) {
                comps[0] = (IComp)((Object)this.getLeftComponent());
            }
            if (this.getRightComponent() instanceof IComp) {
                comps[1] = (IComp)((Object)this.getRightComponent());
            }
        } else {
            if (this.getTopComponent() instanceof IComp) {
                comps[0] = (IComp)((Object)this.getTopComponent());
            }
            if (this.getBottomComponent() instanceof IComp) {
                comps[1] = (IComp)((Object)this.getBottomComponent());
            }
        }
        return comps;
    }

    @Override
    public void updateColor() {
        this.setForeground(MCon.colorSplitDivider());
        IComp[] comps = this.getActiveComps();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].updateColor();
        }
    }

    @Override
    public void updateLang() {
        IComp[] comps = this.getActiveComps();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].updateLang();
        }
    }

    @Override
    @NotNull
    public MSplit title(@NotNull String pTitle) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MSplit text(@NotNull String pText) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MSplit name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    @NotNull
    public String getLangKey() {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    public void add(IComp pComp) {
    }

    @Override
    @Nullable
    public Component add(Component pComp) {
        return null;
    }

    @Override
    public void removeComps() {
    }

    @Override
    public void remove(IComp pComp) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    public void update() {
    }

    @NotNull
    public List<IComp> getComps() {
        return new ArrayList<IComp>(Arrays.asList(this.getActiveComps()));
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    @NotNull
    public static MSplit retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MSplit)MReflection.retrieveComp(pView, pPath, MSplit.class);
    }
}

