/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.view;

import de.maggicraft.mcommons.initialization.IInitializable;
import de.maggicraft.mcommons.util.CCon;
import de.maggicraft.mgui.comp.IComp;
import de.maggicraft.mgui.comp.ICompound;
import de.maggicraft.mgui.listener.MCompListeners;
import de.maggicraft.mgui.pos.MMPos;
import de.maggicraft.mgui.pos.MPos;
import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.util.MReflection;
import de.maggicraft.mgui.view.MScroll;
import de.maggicraft.mgui.view.util.IView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MView<S>
extends JLayeredPane
implements IView,
IInitializable {
    @NotNull
    private List<IComp> mComps = new ArrayList<IComp>();
    @Nullable
    private List<IComp> mStashComps;
    @Nullable
    private IComp mDimComp;
    private MMPos mPos;
    private int mDimWidth = -1;
    private int mDimHeight = -1;
    private boolean mIsInitialized;
    private boolean mInitDisplay;
    private boolean mIsUpdatable = true;

    public MView() {
        this.setVisible(false);
        MCon.styleView(this);
        MCompListeners.compInitialized(this);
    }

    @NotNull
    public static MView retrieve(@NotNull IView pView, @NotNull String pPath) {
        return (MView)MReflection.retrieveComp(pView, pPath, MView.class);
    }

    public void setScroll(@NotNull MScroll pScroll) {
        this.mPos = MPos.pos(pScroll, "||<>m<>,||<>m<>");
        this.mPos.setComp(this);
    }

    @Override
    public void initialize() {
    }

    public void display(S pState) {
        if (!this.mIsInitialized) {
            this.mIsInitialized = true;
            this.mIsUpdatable = false;
            this.initialize();
            this.mIsUpdatable = true;
        }
        this.stash(pState);
        this.mInitDisplay = true;
        this.mIsUpdatable = false;
        this.displayState(pState);
        this.mIsUpdatable = true;
        this.mInitDisplay = false;
        this.mPos.updateView();
        this.repaint();
        this.afterDisplay(pState);
    }

    public void afterDisplay(S pState) {
    }

    protected abstract void displayState(S var1);

    protected void stash(S pState) {
        if (this.mStashComps != null) {
            for (int i = 0; i < this.mStashComps.size(); ++i) {
                this.remove(this.mStashComps.get(i));
            }
        }
        this.mStashComps = new ArrayList<IComp>();
    }

    protected void deinit() {
        this.removeComps();
        this.mIsInitialized = false;
    }

    public void setDim(int pDimWidth, int pDimHeight) {
        this.mDimComp = null;
        this.mDimWidth = pDimWidth;
        this.mDimHeight = pDimHeight;
        this.setPreferredSize(new Dimension(this.mDimWidth, this.mDimHeight));
        this.validate();
    }

    public void setDim(@NotNull IComp pDimComp, int pDimWidth) {
        if (!(pDimComp instanceof Component)) {
            throw new ClassCastException("must be instance of Component");
        }
        boolean tmp = this.mIsUpdatable;
        this.mIsUpdatable = true;
        this.update();
        this.mIsUpdatable = tmp;
        this.mDimComp = pDimComp;
        this.mDimWidth = pDimWidth;
        this.mDimHeight = -1;
        this.updateDim();
    }

    private void updateDim() {
        if (this.mDimComp == null) {
            return;
        }
        MMPos pos = this.mDimComp.getPos();
        pos.updateComp(0, 0, this.getDimWidth(), this.getDimHeight());
        Rectangle bounds = ((Component)((Object)this.mDimComp)).getBounds();
        pos.updateComp(0, 0, this.getWidth(), this.getHeight());
        int height = bounds.y + bounds.height;
        if (pos instanceof MPos) {
            height += ((MPos)pos).getGapSouth();
        }
        this.setPreferredSize(new Dimension(this.mDimWidth, height));
        this.validate();
    }

    public Object getDefaultState() {
        return -1;
    }

    private int getDimWidth() {
        if (this.mDimComp == null) {
            return this.getWidth();
        }
        return Math.max(this.mDimWidth, this.getWidth());
    }

    private int getDimHeight() {
        if (this.mDimComp == null) {
            return this.getHeight();
        }
        return 65535;
    }

    @Override
    public void updateColor() {
        this.setBackground(MCon.colorFrame());
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).updateColor();
        }
    }

    @Override
    public void updateLang() {
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).updateLang();
        }
    }

    @Override
    @NotNull
    public MView title(@NotNull String pTitle) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MView text(@NotNull String pText) {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public String getLangKey() {
        throw CCon.NOT_SUPPORTED;
    }

    @Override
    @NotNull
    public MView name(String pName) {
        this.setName(pName);
        return this;
    }

    @Override
    public void add(IComp pComp) {
        this.add(pComp, 0);
    }

    public void add(IComp pComp, int pLayer) {
        this.mComps.add(pComp);
        this.setLayer((Component)((Object)pComp), pLayer);
        this.add((Component)((Object)pComp));
        if (this.mInitDisplay) {
            this.mStashComps.add(pComp);
        }
    }

    @Override
    public void removeComps() {
        for (int i = 0; i < this.mComps.size(); ++i) {
            IComp comp = this.mComps.get(i);
            if (comp instanceof IView) {
                ((IView)comp).removeComps();
            }
            if (comp instanceof ICompound) {
                ((ICompound)((Object)comp)).remove();
            }
            this.remove((Component)((Object)comp));
            comp.deinitialize();
        }
        this.mComps = new ArrayList<IComp>();
    }

    @Override
    public void remove(IComp pComp) {
        this.mComps.remove(pComp);
        if (pComp instanceof IView) {
            ((IView)pComp).removeComps();
        }
        if (pComp instanceof ICompound) {
            ((ICompound)((Object)pComp)).remove();
        }
        this.remove((Component)((Object)pComp));
        pComp.deinitialize();
    }

    @Override
    public void update() {
        if (!this.isUpdatable()) {
            return;
        }
        for (int i = 0; i < this.mComps.size(); ++i) {
            this.mComps.get(i).getPos().updateComp(0, 0, this.getWidth(), this.getHeight());
        }
        this.updateDim();
    }

    @Override
    public void setVisible(boolean pVisible) {
        super.setVisible(pVisible);
        if (pVisible) {
            this.update();
        }
    }

    @NotNull
    public List<IComp> getComps() {
        return this.mComps;
    }

    @Override
    public boolean isUpdatable() {
        return this.isVisible() && this.mIsUpdatable;
    }

    @Override
    public void setBounds(int pX, int pY, int pWidth, int pHeight) {
        super.setBounds(pX, pY, pWidth, pHeight);
        this.update();
    }

    @Override
    public MMPos getPos() {
        return this.mPos;
    }

    public List<IComp> getStashComps() {
        return this.mStashComps;
    }
}

