/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.view.util;

import de.maggicraft.mgui.schemes.MCon;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.jetbrains.annotations.NotNull;

public class MScrollBarUI
extends BasicScrollBarUI {
    private final JScrollPane mScroll;

    public MScrollBarUI(JScrollPane pScroll) {
        this.mScroll = pScroll;
    }

    @Override
    @NotNull
    protected JButton createDecreaseButton(int pOrientation) {
        return new InvisibleScrollBarButton();
    }

    @Override
    @NotNull
    protected JButton createIncreaseButton(int pOrientation) {
        return new InvisibleScrollBarButton();
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
    }

    @Override
    public void paintThumb(@NotNull Graphics g, JComponent c, @NotNull Rectangle thumbBounds) {
        int orientation = this.scrollbar.getOrientation();
        int width = MCon.scrollThumbSize();
        int height = MCon.scrollThumbSize();
        if (orientation == 1) {
            height = thumbBounds.height;
            if (height < MCon.scrollThumbSize()) {
                height = MCon.scrollThumbSize();
            }
        } else {
            width = thumbBounds.width;
            if (width < MCon.scrollThumbSize()) {
                width = MCon.scrollThumbSize();
            }
        }
        Graphics2D graphics2D = (Graphics2D)g.create();
        graphics2D.setColor(this.isThumbRollover() ? MCon.colorScrollThumbRollover() : MCon.colorScrollThumb());
        graphics2D.fillRect(thumbBounds.x, thumbBounds.y, width, height);
        graphics2D.dispose();
    }

    @Override
    protected void setThumbBounds(int x, int y, int width, int height) {
        super.setThumbBounds(x, y, width, height);
        this.mScroll.repaint();
    }

    private static class InvisibleScrollBarButton
    extends JButton {
        private InvisibleScrollBarButton() {
            this.setOpaque(false);
            this.setFocusable(false);
            this.setFocusPainted(false);
            this.setBorderPainted(false);
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

