/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.view.util;

import de.maggicraft.mgui.schemes.MCon;
import de.maggicraft.mgui.view.util.MScrollBarUI;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import org.jetbrains.annotations.NotNull;

public final class MScrollPaneStyle {
    private MScrollPaneStyle() {
    }

    public static void styleScroll(@NotNull JScrollPane pScroll) {
        pScroll.setBorder(null);
        JScrollBar verticalScrollBar = pScroll.getVerticalScrollBar();
        verticalScrollBar.setOpaque(false);
        verticalScrollBar.setUI(new MScrollBarUI(pScroll));
        JScrollBar horizontalScrollBar = pScroll.getHorizontalScrollBar();
        horizontalScrollBar.setOpaque(false);
        horizontalScrollBar.setUI(new MScrollBarUI(pScroll));
        pScroll.setLayout(new ScrollPaneLayout(){

            @Override
            public void layoutContainer(@NotNull Container parent) {
                Rectangle availR = parent.getBounds();
                availR.y = 0;
                availR.x = 0;
                Insets insets = parent.getInsets();
                availR.x = insets.left;
                availR.y = insets.top;
                availR.width -= insets.left + insets.right;
                availR.height -= insets.top + insets.bottom;
                if (this.viewport != null) {
                    this.viewport.setBounds(availR);
                }
                boolean vsbNeeded = MScrollPaneStyle.isVerticalScrollBarNecessary(this.getViewport());
                boolean hsbNeeded = MScrollPaneStyle.isHorizontalScrollBarNecessary(this.getViewport());
                Rectangle vsbR = new Rectangle();
                vsbR.width = MCon.scrollThumbSize();
                vsbR.height = availR.height - (hsbNeeded ? vsbR.width : 0);
                vsbR.x = availR.x + availR.width - vsbR.width;
                vsbR.y = availR.y;
                if (this.vsb != null) {
                    this.vsb.setBounds(vsbR);
                }
                Rectangle hsbR = new Rectangle();
                hsbR.height = MCon.scrollThumbSize();
                hsbR.width = availR.width - (vsbNeeded ? hsbR.height : 0);
                hsbR.x = availR.x;
                hsbR.y = availR.y + availR.height - hsbR.height;
                if (this.hsb != null) {
                    this.hsb.setBounds(hsbR);
                }
            }
        });
        pScroll.setComponentZOrder(pScroll.getVerticalScrollBar(), 0);
        pScroll.setComponentZOrder(pScroll.getHorizontalScrollBar(), 1);
        pScroll.setComponentZOrder(pScroll.getViewport(), 2);
    }

    public static boolean isVerticalScrollBarNecessary(@NotNull JViewport pViewport) {
        Rectangle viewRect = pViewport.getViewRect();
        Dimension viewSize = pViewport.getViewSize();
        return viewSize.getHeight() > viewRect.getHeight();
    }

    public static boolean isHorizontalScrollBarNecessary(@NotNull JViewport pViewport) {
        Rectangle viewRect = pViewport.getViewRect();
        Dimension viewSize = pViewport.getViewSize();
        return viewSize.getWidth() > viewRect.getWidth();
    }
}

