/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mgui.view.util;

import de.maggicraft.mcommons.settings.ISetting;
import de.maggicraft.mgui.view.util.EWindowSize;
import de.maggicraft.mgui.view.util.IWinStore;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;

public class MWinStore
implements IWinStore {
    private static final String SEP = ",";
    private JFrame mFrame;
    private String mName;
    private ISetting<String> mSetting;
    @NotNull
    private short[] mDim = new short[9];

    public MWinStore() {
    }

    public MWinStore(int pSetting) {
        this.set(pSetting);
        this.min(EWindowSize.TWO);
    }

    @NotNull
    public MWinStore addSetting(ISetting<String> pSetting) {
        this.mSetting = pSetting;
        return this;
    }

    @NotNull
    public MWinStore pos(int pPosX, int pPosY) {
        this.mDim[1] = (short)pPosX;
        this.mDim[2] = (short)pPosY;
        return this.remove(4);
    }

    @NotNull
    public MWinStore start(@NotNull EWindowSize pWindowSize) {
        this.mDim[3] = (short)pWindowSize.getDimX();
        this.mDim[4] = (short)pWindowSize.getDimY();
        return pWindowSize == EWindowSize.FULL_SCREEN ? this.set(8) : this.remove(8);
    }

    @NotNull
    public MWinStore start(int pStartWidth, int pStartHeight) {
        this.mDim[3] = (short)pStartWidth;
        this.mDim[4] = (short)pStartHeight;
        return this.remove(8);
    }

    @NotNull
    public MWinStore min(@NotNull EWindowSize pWindowSize) {
        this.mDim[5] = (short)pWindowSize.getDimX();
        this.mDim[6] = (short)pWindowSize.getDimY();
        return this.set(64);
    }

    @NotNull
    public MWinStore min(int pMinWidth, int pMinHeight) {
        this.mDim[5] = (short)pMinWidth;
        this.mDim[6] = (short)pMinHeight;
        return this.set(64);
    }

    @NotNull
    public MWinStore max(@NotNull EWindowSize pWindowSize) {
        this.mDim[7] = (short)pWindowSize.getDimX();
        this.mDim[8] = (short)pWindowSize.getDimY();
        return this.set(128);
    }

    @NotNull
    public MWinStore max(int pMaxWidth, int pMaxHeight) {
        this.mDim[7] = (short)pMaxWidth;
        this.mDim[8] = (short)pMaxHeight;
        return this.set(128);
    }

    @NotNull
    public MWinStore store(String pName) {
        this.mName = pName;
        return this.set(1);
    }

    @NotNull
    public MWinStore setFrame(JFrame pFrame) {
        this.mFrame = pFrame;
        return this;
    }

    public void position() {
        String value;
        boolean hasRead = false;
        if (this.is(1) && !(value = this.mSetting.getValue()).isEmpty()) {
            char ch = value.charAt(0);
            if (ch == 'd') {
                this.mSetting.setValue("c");
            } else if (ch == 'f') {
                this.set(8);
            } else if (ch != 'c') {
                String[] parts = value.split(SEP);
                this.mDim[1] = Short.parseShort(parts[0]);
                this.mDim[2] = Short.parseShort(parts[1]);
                this.mDim[3] = Short.parseShort(parts[2]);
                this.mDim[4] = Short.parseShort(parts[3]);
                hasRead = true;
            }
        }
        if (this.is(64)) {
            this.mFrame.setMinimumSize(new Dimension(this.mDim[5], this.mDim[6]));
        }
        if (this.is(128)) {
            this.mFrame.setMaximumSize(new Dimension(this.mDim[7], this.mDim[8]));
        }
        if (!(!this.is(4) || this.is(1) && this.is(2) || this.is(8) || hasRead)) {
            this.mFrame.setSize(this.mDim[3], this.mDim[4]);
            this.mFrame.setLocationRelativeTo(null);
        } else if (this.is(8) && !hasRead) {
            this.mFrame.setExtendedState(6);
        } else {
            this.mFrame.setBounds(this.mDim[1], this.mDim[2], this.mDim[3], this.mDim[4]);
        }
        Container cp = this.mFrame.getContentPane();
        cp.setLayout(null);
        cp.setBounds(0, 0, this.mFrame.getWidth(), this.mFrame.getHeight());
        if (this.is(16)) {
            this.mFrame.setUndecorated(true);
        }
        this.deinit();
    }

    public void savePos() {
        String value;
        if (this.is(1) && ((value = this.mSetting.getValue()).isEmpty() || value.charAt(0) != 'd')) {
            if (this.mFrame.getExtendedState() == 6) {
                this.mSetting.setValue("f");
            } else {
                Point point = this.mFrame.getLocation();
                this.mSetting.setValue(point.x + SEP + point.y + SEP + this.mFrame.getWidth() + SEP + this.mFrame.getHeight());
            }
        }
    }

    private void deinit() {
        this.mDim = new short[]{this.mDim[0]};
    }

    @NotNull
    public MWinStore set(int pSetting) {
        this.mDim[0] = (short)(this.mDim[0] | pSetting);
        return this;
    }

    @NotNull
    public MWinStore remove(int pSetting) {
        this.mDim[0] = (short)(this.mDim[0] & ~pSetting);
        return this;
    }

    public boolean is(int pSetting) {
        return (this.mDim[0] & pSetting) != 0;
    }
}

