/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mioutil.cbstream;

import de.maggicraft.mioutil.cbstream.CBConstants;
import de.maggicraft.mioutil.cbstream.CBMap;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CBInputStream
extends InputStream {
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    @NotNull
    private final CBMap mCrc = new CBMap();
    @NotNull
    private final int[][] mLimit = new int[6][258];
    @NotNull
    private final int[][] mBase = new int[6][258];
    @NotNull
    private final int[][] mPerm = new int[6][258];
    @NotNull
    private final int[] mUnzftab = new int[256];
    @NotNull
    private final int[] mMinLens = new int[6];
    @NotNull
    private final char[] mSeqToUnseq = new char[256];
    @NotNull
    private final char[] mSelector = new char[18002];
    @NotNull
    private final char[] mSelectorMtf = new char[18002];
    @NotNull
    private final boolean[] mInUse = new boolean[256];
    @Nullable
    private InputStream mBsStream;
    @Nullable
    private int[] mTt = null;
    private int mNInUse;
    private int mCurrentChar = -1;
    private int mBlockState = 1;
    private int mComputedCombinedCRC;
    private int mI2;
    private int mCount;
    private int mChPrev;
    private int mCh2;
    private int mTPos;
    private int mRNToGo = 0;
    private int mRTPos = 0;
    private int mJ2;
    private int mLast;
    private int mOrigPtr;
    private int mBsBuff;
    private int mBsLive;
    @Nullable
    private char[] mLl8 = null;
    private char mZ;
    private boolean mStreamEnd = false;
    private boolean mBlockRandomised;

    public CBInputStream(@NotNull File pFile) throws FileNotFoundException {
        this(new FileInputStream(pFile));
    }

    public CBInputStream(InputStream pStream) {
        this.bsSetStream(pStream);
        this.initialize();
        this.initBlock();
        this.setupBlock();
    }

    private static void hbCreateDecodeTables(int[] pLimit, int[] pBase, int[] pPerm, char[] pLength, int pMinLen, int pMaxLen, int pAlphaSize) {
        int i;
        int pp = 0;
        for (i = pMinLen; i <= pMaxLen; ++i) {
            for (int j = 0; j < pAlphaSize; ++j) {
                if (pLength[j] != i) continue;
                pPerm[pp] = j;
                ++pp;
            }
        }
        for (i = 0; i < 23; ++i) {
            pBase[i] = 0;
        }
        for (i = 0; i < pAlphaSize; ++i) {
            int n = pLength[i] + '\u0001';
            pBase[n] = pBase[n] + 1;
        }
        for (i = 1; i < 23; ++i) {
            int n = i;
            pBase[n] = pBase[n] + pBase[i - 1];
        }
        for (i = 0; i < 23; ++i) {
            pLimit[i] = 0;
        }
        int vec = 0;
        for (i = pMinLen; i <= pMaxLen; ++i) {
            pLimit[i] = (vec += pBase[i + 1] - pBase[i]) - 1;
            vec <<= 1;
        }
        for (i = pMinLen + 1; i <= pMaxLen; ++i) {
            pBase[i] = (pLimit[i - 1] + 1 << 1) - pBase[i];
        }
    }

    public final char readChar() throws EOFException {
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((ch1 << 8) + ch2);
    }

    public final int readInt() throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.read();
        if ((ch1 | (ch2 = this.read()) | (ch3 = this.read()) | (ch4 = this.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    @Override
    public int read() {
        if (this.mStreamEnd) {
            return -1;
        }
        int retChar = this.mCurrentChar;
        switch (this.mBlockState) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setupRandPartB();
                break;
            }
            case 4: {
                this.setupRandPartC();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setupNoRandPartB();
                break;
            }
            case 7: {
                this.setupNoRandPartC();
                break;
            }
        }
        return retChar;
    }

    @Override
    public void close() throws IOException {
        if (this.mBsStream != null) {
            this.mBsStream.close();
        }
    }

    private void makeMaps() {
        this.mNInUse = 0;
        for (int i = 0; i < 256; ++i) {
            if (!this.mInUse[i]) continue;
            this.mSeqToUnseq[this.mNInUse] = (char)i;
            ++this.mNInUse;
        }
    }

    private void initialize() {
        char magic3 = this.bsGetUChar();
        char magic4 = this.bsGetUChar();
        if (magic3 != 'h' || magic4 < '1' || magic4 > '9') {
            this.bsFinishedWithStream();
            this.mStreamEnd = true;
            return;
        }
        this.setDecompressStructureSizes(magic4 - 48);
        this.mComputedCombinedCRC = 0;
    }

    private void initBlock() {
        char magic1 = this.bsGetUChar();
        char magic2 = this.bsGetUChar();
        char magic3 = this.bsGetUChar();
        char magic4 = this.bsGetUChar();
        char magic5 = this.bsGetUChar();
        char magic6 = this.bsGetUChar();
        if (magic1 == '\u0017' && magic2 == 'r' && magic3 == 'E' && magic4 == '8' && magic5 == 'P' && magic6 == '\u0090') {
            this.complete();
            return;
        }
        if (magic1 != '1' || magic2 != 'A' || magic3 != 'Y' || magic4 != '&' || magic5 != 'S' || magic6 != 'Y') {
            this.mStreamEnd = true;
            return;
        }
        this.bsGetInt32();
        this.mBlockRandomised = this.bsR(1) == 1;
        this.getAndMoveToFrontDecode();
        this.mCrc.initialiseCRC();
        this.mBlockState = 1;
    }

    private void endBlock() {
        int computedBlockCRC = this.mCrc.getFinalCRC();
        this.mComputedCombinedCRC = this.mComputedCombinedCRC << 1 | this.mComputedCombinedCRC >>> 31;
        this.mComputedCombinedCRC ^= computedBlockCRC;
    }

    private void complete() {
        this.bsGetInt32();
        this.bsFinishedWithStream();
        this.mStreamEnd = true;
    }

    private void bsFinishedWithStream() {
        try {
            if (this.mBsStream != null && this.mBsStream != System.in) {
                this.mBsStream.close();
                this.mBsStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void bsSetStream(InputStream f) {
        this.mBsStream = f;
        this.mBsLive = 0;
        this.mBsBuff = 0;
    }

    private int bsR(int n) {
        while (this.mBsLive < n) {
            char thech = '\u0000';
            try {
                thech = (char)this.mBsStream.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            char zzi = thech;
            this.mBsBuff = this.mBsBuff << 8 | zzi & 0xFF;
            this.mBsLive += 8;
        }
        int v = this.mBsBuff >> this.mBsLive - n & (1 << n) - 1;
        this.mBsLive -= n;
        return v;
    }

    private char bsGetUChar() {
        return (char)this.bsR(8);
    }

    private void bsGetint() {
        this.bsR(8);
        this.bsR(8);
        this.bsR(8);
        this.bsR(8);
    }

    private void bsGetInt32() {
        this.bsGetint();
    }

    private void recvDecodingTables() {
        int t;
        int v;
        int j;
        int i;
        char[][] len = new char[6][258];
        boolean[] inUse16 = new boolean[16];
        for (i = 0; i < 16; ++i) {
            inUse16[i] = this.bsR(1) == 1;
        }
        for (i = 0; i < 256; ++i) {
            this.mInUse[i] = false;
        }
        for (i = 0; i < 16; ++i) {
            if (!inUse16[i]) continue;
            for (j = 0; j < 16; ++j) {
                if (this.bsR(1) != 1) continue;
                this.mInUse[i * 16 + j] = true;
            }
        }
        this.makeMaps();
        int alphaSize = this.mNInUse + 2;
        int nGroups = this.bsR(3);
        int nSelectors = this.bsR(15);
        for (i = 0; i < nSelectors; ++i) {
            j = 0;
            while (this.bsR(1) == 1) {
                ++j;
            }
            this.mSelectorMtf[i] = (char)j;
        }
        char[] pos = new char[6];
        for (v = 0; v < nGroups; v = (int)((char)(v + 1))) {
            pos[v] = v;
        }
        for (i = 0; i < nSelectors; ++i) {
            char tmp = pos[v];
            for (v = this.mSelectorMtf[i]; v > 0; v = (int)((char)(v - 1))) {
                pos[v] = pos[v - 1];
            }
            pos[0] = tmp;
            this.mSelector[i] = tmp;
        }
        for (t = 0; t < nGroups; ++t) {
            int curr = this.bsR(5);
            for (i = 0; i < alphaSize; ++i) {
                while (this.bsR(1) == 1) {
                    if (this.bsR(1) == 0) {
                        ++curr;
                        continue;
                    }
                    --curr;
                }
                len[t][i] = (char)curr;
            }
        }
        for (t = 0; t < nGroups; ++t) {
            int minLen = 32;
            char maxLen = '\u0000';
            for (i = 0; i < alphaSize; ++i) {
                if (len[t][i] > maxLen) {
                    maxLen = len[t][i];
                }
                if (len[t][i] >= minLen) continue;
                minLen = len[t][i];
            }
            CBInputStream.hbCreateDecodeTables(this.mLimit[t], this.mBase[t], this.mPerm[t], len[t], minLen, maxLen, alphaSize);
            this.mMinLens[t] = minLen;
        }
    }

    private void getAndMoveToFrontDecode() {
        int i;
        char[] yy = new char[256];
        this.mOrigPtr = this.bsR(24);
        this.recvDecodingTables();
        int EOB = this.mNInUse + 1;
        int groupNo = -1;
        for (i = 0; i <= 255; ++i) {
            this.mUnzftab[i] = 0;
        }
        for (i = 0; i <= 255; ++i) {
            yy[i] = (char)i;
        }
        this.mLast = -1;
        int groupPos = 50;
        --groupPos;
        char zt = this.mSelector[++groupNo];
        int zn = this.mMinLens[zt];
        int zvec = this.bsR(zn);
        while (zvec > this.mLimit[zt][zn]) {
            ++zn;
            while (this.mBsLive < 1) {
                char thech = '\u0000';
                try {
                    thech = (char)this.mBsStream.read();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                char zzi = thech;
                this.mBsBuff = this.mBsBuff << 8 | zzi & 0xFF;
                this.mBsLive += 8;
            }
            int zj = this.mBsBuff >> this.mBsLive - 1 & 1;
            --this.mBsLive;
            zvec = zvec << 1 | zj;
        }
        int nextSym = this.mPerm[zt][zvec - this.mBase[zt][zn]];
        while (nextSym != EOB) {
            int j;
            if (nextSym == 0 || nextSym == 1) {
                char ch;
                int zn2;
                int zvec2;
                char zt2;
                int s = -1;
                int N = 1;
                do {
                    s = nextSym == 0 ? (s += N) : (s += 2 * N);
                    N *= 2;
                    if (groupPos == 0) {
                        ++groupNo;
                        groupPos = 50;
                    }
                    --groupPos;
                    zt2 = this.mSelector[groupNo];
                    zn2 = this.mMinLens[zt2];
                    zvec2 = this.bsR(zn2);
                    while (zvec2 > this.mLimit[zt2][zn2]) {
                        ++zn2;
                        while (this.mBsLive < 1) {
                            char thech = '\u0000';
                            try {
                                thech = (char)this.mBsStream.read();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            char zzi = thech;
                            this.mBsBuff = this.mBsBuff << 8 | zzi & 0xFF;
                            this.mBsLive += 8;
                        }
                        int zj = this.mBsBuff >> this.mBsLive - 1 & 1;
                        --this.mBsLive;
                        zvec2 = zvec2 << 1 | zj;
                    }
                } while ((nextSym = this.mPerm[zt2][zvec2 - this.mBase[zt2][zn2]]) == 0 || nextSym == 1);
                char c = ch = this.mSeqToUnseq[yy[0]];
                this.mUnzftab[c] = this.mUnzftab[c] + ++s;
                while (s > 0) {
                    ++this.mLast;
                    this.mLl8[this.mLast] = ch;
                    --s;
                }
                continue;
            }
            ++this.mLast;
            char tmp = yy[nextSym - 1];
            char c = this.mSeqToUnseq[tmp];
            this.mUnzftab[c] = this.mUnzftab[c] + 1;
            this.mLl8[this.mLast] = this.mSeqToUnseq[tmp];
            for (j = nextSym - 1; j > 3; j -= 4) {
                yy[j] = yy[j - 1];
                yy[j - 1] = yy[j - 2];
                yy[j - 2] = yy[j - 3];
                yy[j - 3] = yy[j - 4];
            }
            while (j > 0) {
                yy[j] = yy[j - 1];
                --j;
            }
            yy[0] = tmp;
            if (groupPos == 0) {
                ++groupNo;
                groupPos = 50;
            }
            --groupPos;
            char zt3 = this.mSelector[groupNo];
            int zn3 = this.mMinLens[zt3];
            int zvec3 = this.bsR(zn3);
            while (zvec3 > this.mLimit[zt3][zn3]) {
                ++zn3;
                while (this.mBsLive < 1) {
                    char thech = '\u0000';
                    try {
                        thech = (char)this.mBsStream.read();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    char zzi = thech;
                    this.mBsBuff = this.mBsBuff << 8 | zzi & 0xFF;
                    this.mBsLive += 8;
                }
                int zj = this.mBsBuff >> this.mBsLive - 1 & 1;
                --this.mBsLive;
                zvec3 = zvec3 << 1 | zj;
            }
            nextSym = this.mPerm[zt3][zvec3 - this.mBase[zt3][zn3]];
        }
    }

    private void setupBlock() {
        int i;
        int[] cftab = new int[257];
        cftab[0] = 0;
        for (i = 1; i <= 256; ++i) {
            cftab[i] = this.mUnzftab[i - 1];
        }
        for (i = 1; i <= 256; ++i) {
            int n = i;
            cftab[n] = cftab[n] + cftab[i - 1];
        }
        i = 0;
        while (i <= this.mLast) {
            char ch = this.mLl8[i];
            this.mTt[cftab[ch]] = i++;
            char c = ch;
            cftab[c] = cftab[c] + 1;
        }
        this.mTPos = this.mTt[this.mOrigPtr];
        this.mCount = 0;
        this.mI2 = 0;
        this.mCh2 = 256;
        if (this.mBlockRandomised) {
            this.mRNToGo = 0;
            this.mRTPos = 0;
            this.setupRandPartA();
        } else {
            this.setupNoRandPartA();
        }
    }

    private void setupRandPartA() {
        if (this.mI2 > this.mLast) {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        } else {
            this.mChPrev = this.mCh2;
            this.mCh2 = this.mLl8[this.mTPos];
            this.mTPos = this.mTt[this.mTPos];
            if (this.mRNToGo == 0) {
                this.mRNToGo = CBConstants.R_NUMS[this.mRTPos];
                ++this.mRTPos;
                if (this.mRTPos == 512) {
                    this.mRTPos = 0;
                }
            }
            --this.mRNToGo;
            this.mCh2 ^= this.mRNToGo == 1 ? 1 : 0;
            ++this.mI2;
            this.mCurrentChar = this.mCh2;
            this.mBlockState = 3;
            this.mCrc.updateCRC(this.mCh2);
        }
    }

    private void setupNoRandPartA() {
        if (this.mI2 <= this.mLast) {
            this.mChPrev = this.mCh2;
            this.mCh2 = this.mLl8[this.mTPos];
            this.mTPos = this.mTt[this.mTPos];
            ++this.mI2;
            this.mCurrentChar = this.mCh2;
            this.mBlockState = 6;
            this.mCrc.updateCRC(this.mCh2);
        } else {
            this.endBlock();
            this.initBlock();
            this.setupBlock();
        }
    }

    private void setupRandPartB() {
        if (this.mCh2 == this.mChPrev) {
            ++this.mCount;
            if (this.mCount >= 4) {
                this.mZ = this.mLl8[this.mTPos];
                this.mTPos = this.mTt[this.mTPos];
                if (this.mRNToGo == 0) {
                    this.mRNToGo = CBConstants.R_NUMS[this.mRTPos];
                    ++this.mRTPos;
                    if (this.mRTPos == 512) {
                        this.mRTPos = 0;
                    }
                }
                --this.mRNToGo;
                this.mZ = (char)(this.mZ ^ (this.mRNToGo == 1 ? (char)'\u0001' : '\u0000'));
                this.mJ2 = 0;
                this.mBlockState = 4;
                this.setupRandPartC();
            } else {
                this.mBlockState = 2;
                this.setupRandPartA();
            }
        } else {
            this.mBlockState = 2;
            this.mCount = 1;
            this.setupRandPartA();
        }
    }

    private void setupRandPartC() {
        if (this.mJ2 < this.mZ) {
            this.mCurrentChar = this.mCh2;
            this.mCrc.updateCRC(this.mCh2);
            ++this.mJ2;
        } else {
            this.mBlockState = 2;
            ++this.mI2;
            this.mCount = 0;
            this.setupRandPartA();
        }
    }

    private void setupNoRandPartB() {
        if (this.mCh2 == this.mChPrev) {
            ++this.mCount;
            if (this.mCount >= 4) {
                this.mZ = this.mLl8[this.mTPos];
                this.mTPos = this.mTt[this.mTPos];
                this.mBlockState = 7;
                this.mJ2 = 0;
                this.setupNoRandPartC();
            } else {
                this.mBlockState = 5;
                this.setupNoRandPartA();
            }
        } else {
            this.mBlockState = 5;
            this.mCount = 1;
            this.setupNoRandPartA();
        }
    }

    private void setupNoRandPartC() {
        if (this.mJ2 < this.mZ) {
            this.mCurrentChar = this.mCh2;
            this.mCrc.updateCRC(this.mCh2);
            ++this.mJ2;
        } else {
            this.mBlockState = 5;
            ++this.mI2;
            this.mCount = 0;
            this.setupNoRandPartA();
        }
    }

    private void setDecompressStructureSizes(int pNewSize100K) {
        if (pNewSize100K == 0) {
            return;
        }
        int n = 100000 * pNewSize100K;
        this.mLl8 = new char[n];
        this.mTt = new int[n];
    }
}

