/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mioutil.compr;

import de.maggicraft.mioutil.compr.CompressedUtil;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Compressed {
    @NotNull
    private final int[] mStorage;
    private final int mBits;
    private final int mUnits;

    public Compressed(int ... pInts) {
        this(pInts.length, CompressedUtil.bitLength(pInts));
        this.set(pInts);
    }

    public Compressed(int pUnits, int pBits) {
        this.mUnits = pUnits;
        this.mBits = pBits;
        int size = (int)Math.ceil((float)(this.mUnits * this.mBits) / 32.0f);
        this.mStorage = new int[size];
    }

    public void set(int ... pInts) {
        for (int i = 0; i < pInts.length; ++i) {
            this.set(i, pInts[i]);
        }
    }

    public void set(int pUnit, int pValue) {
        for (int i = this.mBits - 1; i >= 0; --i) {
            int bit = pUnit * this.mBits + i;
            if ((pValue >> i & 1) == 1) {
                int n = bit / 32;
                this.mStorage[n] = this.mStorage[n] | 1 << bit % 32;
                continue;
            }
            int n = bit / 32;
            this.mStorage[n] = this.mStorage[n] & ~(1 << bit % 32);
        }
    }

    public int get(int pUnit) {
        int value = 0;
        for (int i = 0; i < this.mBits; ++i) {
            int bit = pUnit * this.mBits + i;
            value |= (this.mStorage[bit / 32] >> bit % 32 & 1) << i;
        }
        return value;
    }

    public boolean equals(Object pObject) {
        if (this == pObject) {
            return true;
        }
        if (pObject == null || this.getClass() != pObject.getClass()) {
            return false;
        }
        Compressed that = (Compressed)pObject;
        return this.mBits == that.mBits && this.mUnits == that.mUnits && Arrays.equals(this.mStorage, that.mStorage);
    }

    public int hashCode() {
        int result = Objects.hash(this.mBits, this.mUnits);
        result = 31 * result + Arrays.hashCode(this.mStorage);
        return result;
    }

    public int size() {
        return this.mUnits;
    }

    public int getBits() {
        return this.mBits;
    }
}

