/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mioutil.compr;

import de.maggicraft.mioutil.compr.CompressedUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompressedText {
    @NotNull
    private final int[][] mStorage;
    @NotNull
    private final char[] mDecompress;
    private final int mBits;
    @Nullable
    private int[] mCompress;

    public CompressedText(@NotNull char[] pDecompress, int pQuantity) {
        this.mDecompress = pDecompress;
        this.mStorage = new int[pQuantity][];
        this.mCompress = CompressedText.compressTable(pDecompress);
        this.mBits = CompressedText.bitLength(pDecompress);
    }

    public CompressedText(String ... pTexts) {
        this.mDecompress = CompressedText.decompressTable(pTexts);
        this.mStorage = new int[pTexts.length][];
        this.mCompress = CompressedText.compressTable(this.mDecompress);
        this.mBits = CompressedText.bitLength(this.mDecompress);
        this.set(pTexts);
    }

    @NotNull
    public static int[] compressTable(@NotNull char[] pDecompress) {
        char max = '\u0000';
        for (char decompress : pDecompress) {
            if (decompress <= max) continue;
            max = decompress;
        }
        int[] table = new int[max + 1];
        for (int i = 0; i < table.length; i = (int)((char)(i + 1))) {
            for (int j = 0; j < pDecompress.length; j = (int)((char)(j + 1))) {
                if (pDecompress[j] != i) continue;
                table[i] = j;
            }
        }
        return table;
    }

    public static int bitLength(@NotNull char[] pDecompress) {
        return CompressedUtil.bitLength(pDecompress.length);
    }

    @NotNull
    public static char[] decompressTable(String ... pText) {
        HashSet<Character> mDifChars = new HashSet<Character>();
        for (String s : pText) {
            if (s == null) continue;
            for (int i = 0; i < s.length(); ++i) {
                mDifChars.add(Character.valueOf(s.charAt(i)));
            }
        }
        char[] chars = new char[mDifChars.size() + 1];
        int i = 1;
        for (Character ch : mDifChars) {
            chars[i] = ch.charValue();
            ++i;
        }
        return chars;
    }

    public static int bitLength(String ... pText) {
        HashSet<Character> mDifChars = new HashSet<Character>();
        for (String s : pText) {
            if (s == null) continue;
            for (int i = 0; i < s.length(); ++i) {
                mDifChars.add(Character.valueOf(s.charAt(i)));
            }
        }
        return CompressedUtil.bitLength(mDifChars.size() + 1);
    }

    public void set(String ... pTexts) {
        for (int i = 0; i < pTexts.length; ++i) {
            if (pTexts[i] == null) continue;
            this.set(i, pTexts[i]);
        }
        this.resetTable();
    }

    public void set(int pUnit, @NotNull String pText) {
        this.mStorage[pUnit] = new int[(int)Math.ceil((float)(pText.length() * this.mBits) / 32.0f)];
        for (int i = 0; i < pText.length(); ++i) {
            int value = this.mCompress[pText.charAt(i)];
            for (int j = this.mBits - 1; j >= 0; --j) {
                this.setBit(pUnit, i * this.mBits + j, (value >> j & 1) == 1);
            }
        }
    }

    public void resetTable() {
        this.mCompress = null;
    }

    private void setBit(int pUnit, int pBit, boolean pValue) {
        if (pValue) {
            int[] nArray = this.mStorage[pUnit];
            int n = pBit / 32;
            nArray[n] = nArray[n] | 1 << pBit % 32;
        } else {
            int[] nArray = this.mStorage[pUnit];
            int n = pBit / 32;
            nArray[n] = nArray[n] & ~(1 << pBit % 32);
        }
    }

    @NotNull
    public String get(int pUnit) {
        String text = "";
        int maxChars = this.mStorage[pUnit].length * 32 / this.mBits;
        for (int i = 0; i < maxChars; ++i) {
            int val = this.get(pUnit, i);
            if (val == 0) {
                return text;
            }
            text = text + this.mDecompress[val];
        }
        return text;
    }

    public int get(int pUnit, int pBit) {
        int value = 0;
        for (int i = 0; i < this.mBits; ++i) {
            int bit = pBit * this.mBits + i;
            value |= (this.mStorage[pUnit][bit / 32] >> bit % 32 & 1) << i;
        }
        return value;
    }

    public int[][] getStorage() {
        return this.mStorage;
    }

    public int size() {
        return this.mStorage.length;
    }

    public int decompressionLength() {
        return this.mDecompress.length;
    }

    public int getBits() {
        return this.mBits;
    }
}

