/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mioutil.io;

import de.maggicraft.mioutil.cbstream.CBInputStream;
import de.maggicraft.mioutil.cbstream.CBOutputStream;
import de.maggicraft.mlog.MLog;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class MIOUtil {
    public static final String LINE_SEP = System.getProperty("line.separator");

    public static void write(@NotNull File pFile, @NotNull List pList) {
        MIOUtil.write(pFile, pList, new StringBuilder(), false);
    }

    public static void write(@NotNull File pFile, List pList, @NotNull StringBuilder pSb, boolean pCompress) {
        for (Object obj : pList) {
            pSb.append(obj).append(LINE_SEP);
        }
        MIOUtil.write(pFile, pSb.toString(), pCompress);
    }

    public static void write(@NotNull File pFile, @NotNull String pText, boolean pCompress) {
        if (pCompress) {
            MIOUtil.writeCompressed(pFile, pText);
        } else {
            MIOUtil.write(pFile, pText);
        }
    }

    public static void writeCompressed(@NotNull File pFile, @NotNull String pText) {
        try {
            CBOutputStream out = new CBOutputStream(pFile);
            out.writeChars(pText);
            out.flush();
            out.close();
        }
        catch (IOException pE) {
            MLog.log(pE);
        }
    }

    public static void write(@NotNull File pFile, @NotNull String pText) {
        try {
            FileWriter fw = new FileWriter(pFile);
            fw.write(pText);
            fw.flush();
            fw.close();
        }
        catch (IOException pE) {
            MLog.log(pE);
        }
    }

    public static void write(@NotNull File pFile, @NotNull List pList, boolean pCompress) {
        MIOUtil.write(pFile, pList, new StringBuilder(), pCompress);
    }

    @NotNull
    public static Optional<String> readStr(@NotNull File pFile, boolean pCompressed) {
        if (pCompressed) {
            return MIOUtil.readStr(pFile);
        }
        return MIOUtil.readCompressedStr(pFile);
    }

    @NotNull
    public static Optional<String> readStr(@NotNull File pFile) {
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(new FileReader(pFile));
            while ((line = br.readLine()) != null) {
                sb.append(line).append(LINE_SEP);
            }
            br.close();
            return Optional.of(sb.toString());
        }
        catch (IOException pE) {
            MLog.log(pE);
            return Optional.empty();
        }
    }

    @NotNull
    public static Optional<String> readCompressedStr(@NotNull File pFile) {
        try {
            CBInputStream in = new CBInputStream(pFile);
            StringBuilder sb = new StringBuilder();
            try {
                while (true) {
                    sb.append(in.readChar());
                }
            }
            catch (EOFException pE) {
                in.close();
                return Optional.of(sb.toString());
            }
        }
        catch (IOException pE) {
            MLog.log(pE);
            return Optional.empty();
        }
    }

    @Deprecated
    @NotNull
    public static List<String> readList(@NotNull File pFile, boolean pCompressed) {
        if (pCompressed) {
            return MIOUtil.readCompressedList(pFile);
        }
        return MIOUtil.readList(pFile);
    }

    @Deprecated
    @NotNull
    public static List<String> readCompressedList(@NotNull File pFile) {
        try {
            CBInputStream in = new CBInputStream(pFile);
            ArrayList<String> list = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            try {
                while (true) {
                    char ch;
                    if ((ch = in.readChar()) == '\r' || ch == '\n') {
                        list.add(sb.toString());
                        sb = new StringBuilder();
                        if (ch != '\r' || (ch = in.readChar()) == '\n') continue;
                        sb.append(ch);
                        continue;
                    }
                    sb.append(ch);
                }
            }
            catch (EOFException pE) {
                in.close();
                return list;
            }
        }
        catch (IOException pE) {
            MLog.log(pE);
            return new LinkedList<String>();
        }
    }

    @Deprecated
    @NotNull
    public static List<String> readList(@NotNull File pFile) {
        try {
            String line;
            ArrayList<String> list = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new FileReader(pFile));
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
            br.close();
            return list;
        }
        catch (IOException pE) {
            MLog.log(pE);
            return new LinkedList<String>();
        }
    }

    public static void copyFile(@NotNull String pCopy, @NotNull String pPaste) {
        MIOUtil.copyFile(new File(pCopy), new File(pPaste));
    }

    public static void copyFile(@NotNull File pCopy, @NotNull File pPaste) {
        File folder = pPaste.getParentFile();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        try {
            int bufferSize;
            FileInputStream in = new FileInputStream(pCopy);
            FileOutputStream out = new FileOutputStream(pPaste);
            byte[] buffer = new byte[1024];
            while ((bufferSize = in.read(buffer)) > 0) {
                out.write(buffer, 0, bufferSize);
            }
            in.close();
            out.close();
        }
        catch (IOException pE) {
            MLog.log(pE);
        }
    }

    public static void delete(@NotNull File pFile) throws IOException {
        File[] files;
        if (pFile.isDirectory() && (files = pFile.listFiles()) != null) {
            for (File c : files) {
                MIOUtil.delete(c);
            }
        }
        Files.delete(pFile.toPath());
    }

    public static void listFiles(List<File> pFiles, File pFile) {
        MIOUtil.listFiles(pFiles, pFile, null);
    }

    public static void listFiles(List<File> pFiles, File pFile, FileFilter pFilter) {
        File[] list = pFilter == null ? pFile.listFiles() : pFile.listFiles(pFilter);
        if (list == null) {
            return;
        }
        for (File file : list) {
            if (file.isDirectory()) {
                MIOUtil.listFiles(pFiles, file, pFilter);
                continue;
            }
            pFiles.add(file);
        }
    }
}

