/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mioutil.json;

import de.maggicraft.mioutil.io.MIOUtil;
import de.maggicraft.mioutil.json.IJSONManager;
import de.maggicraft.mioutil.json.IStorable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public interface IStorableManager<V extends IStorable>
extends IStorable,
IJSONManager {
    default public void store() {
        MIOUtil.write(this.getFile(), this.toJSON().toJSONString());
    }

    @Override
    @NotNull
    default public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        this.storeHeader(json);
        Collection<V> storables = this.getStorables();
        JSONArray array = new JSONArray();
        for (IStorable storable : storables) {
            array.add(storable.toJSON());
        }
        json.put("entities", array);
        return json;
    }

    public void storeHeader(@NotNull JSONObject var1);

    @NotNull
    public Collection<V> getStorables();
}

