/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mioutil.json;

import de.maggicraft.mioutil.json.IUniqueID;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class ReadableUtil {
    private ReadableUtil() {
    }

    public static boolean contains(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID) {
        return pJSON.containsKey(pUID.getUID());
    }

    public static String[] getStringArray(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID) {
        JSONArray array = ReadableUtil.getArray(pJSON, pUID);
        String[] texts = new String[array.size()];
        int i = 0;
        for (Object object : array) {
            texts[i] = (String)object;
            ++i;
        }
        return texts;
    }

    @NotNull
    public static JSONArray getArray(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID) {
        return (JSONArray)ReadableUtil.getObject(pJSON, pUID);
    }

    @NotNull
    public static Date getDate(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID) {
        return new Date(ReadableUtil.getLong(pJSON, pUID));
    }

    public static long getLong(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID) {
        return (Long)ReadableUtil.getObject(pJSON, pUID);
    }

    @NotNull
    public static String getString(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID) {
        return (String)ReadableUtil.getObject(pJSON, pUID);
    }

    public static int getInt(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID) {
        Object object = ReadableUtil.getObject(pJSON, pUID);
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        return (Integer)object;
    }

    @NotNull
    public static Integer getInteger(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID) {
        Object object = ReadableUtil.getObject(pJSON, pUID);
        if (object instanceof Long) {
            return (int)((Long)object).longValue();
        }
        return (Integer)object;
    }

    public static boolean getBool(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID) {
        return (Boolean)ReadableUtil.getObject(pJSON, pUID);
    }

    @NotNull
    public static JSONObject getJSON(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID) {
        return (JSONObject)ReadableUtil.getObject(pJSON, pUID);
    }

    @NotNull
    public static Object getObject(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID) {
        return pJSON.get(pUID.getUID());
    }
}

