/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mioutil.json;

import de.maggicraft.mioutil.json.IStorable;
import de.maggicraft.mioutil.json.IUniqueID;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class StorableUtil {
    private StorableUtil() {
    }

    public static void put(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID, @NotNull Collection<? extends IStorable> pStorables) {
        JSONArray lists = new JSONArray();
        for (IStorable iStorable : pStorables) {
            lists.add(iStorable.toJSON());
        }
        pJSON.put(pUID.getUID(), lists);
    }

    public static void put(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID, @NotNull String[] pText) {
        JSONArray lists = new JSONArray();
        lists.addAll(Arrays.asList(pText));
        pJSON.put(pUID.getUID(), lists);
    }

    public static void put(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID, @NotNull Date pDate) {
        pJSON.put(pUID.getUID(), pDate.getTime());
    }

    public static void put(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID, @NotNull String pText) {
        pJSON.put(pUID.getUID(), pText);
    }

    public static void put(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID, @NotNull Long pLong) {
        pJSON.put(pUID.getUID(), pLong);
    }

    public static void put(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID, long pLong) {
        pJSON.put(pUID.getUID(), pLong);
    }

    public static void put(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID, @NotNull Integer pInteger) {
        pJSON.put(pUID.getUID(), pInteger);
    }

    public static void put(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID, int pInt) {
        pJSON.put(pUID.getUID(), pInt);
    }

    public static void put(@NotNull JSONObject pJSON, @NotNull IUniqueID<String> pUID, @NotNull JSONObject pJSONObject) {
        pJSON.put(pUID.getUID(), pJSONObject);
    }
}

