/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mlog;

import de.maggicraft.mlog.ILog;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class MLogImpl
implements ILog {
    private static final String LINE_SEP = System.lineSeparator();
    private SimpleDateFormat mFormat = new SimpleDateFormat("[dd.MM.yyyy-kk:mm:ss:SSS]: ");
    private File mOutput;
    private String mHeader;
    private int mDisplayJavaVersion = 1;
    private boolean mDisplayMessages;

    public MLogImpl() {
    }

    public MLogImpl(@NotNull File pOutput, boolean pDisplayMessages) {
        this.mOutput = pOutput;
        this.mDisplayMessages = pDisplayMessages;
        this.mOutput.getParentFile().mkdirs();
    }

    @Override
    public void log(@NotNull Throwable pStacktrace) {
        this.log(pStacktrace, true);
    }

    @Override
    public void log(@NotNull String pText) {
        this.log(pText, true);
    }

    public void log(@NotNull Throwable pStacktrace, boolean pHeader) {
        StringWriter result = new StringWriter();
        pStacktrace.printStackTrace(new PrintWriter(result));
        this.log(((Object)result).toString(), pHeader);
    }

    @Override
    public void log(@NotNull String pText, @NotNull Throwable pStacktrace) {
        this.log(pText, pStacktrace, true);
    }

    @Override
    public void logNoAnalytics(@NotNull String pText) {
        this.log(pText);
    }

    @Override
    public void logNoAnalytics(@NotNull Throwable pStacktrace) {
        this.log(pStacktrace);
    }

    @Override
    public void logNoAnalytics(@NotNull String pText, @NotNull Throwable pStacktrace) {
        this.log(pText, pStacktrace);
    }

    public void log(@NotNull String pText, @NotNull Throwable pStacktrace, boolean pHeader) {
        StringWriter result = new StringWriter();
        pStacktrace.printStackTrace(new PrintWriter(result));
        this.log(pText + '\t' + result, pHeader);
    }

    public synchronized void log(@NotNull String pText, boolean pHeader) {
        block5: {
            if (pHeader) {
                String jreVersion = this.mDisplayJavaVersion > 0 ? System.getProperty("java.version") + ' ' : "";
                pText = this.mHeader + jreVersion + this.getTimeStamp() + pText + LINE_SEP;
            } else {
                pText = pText + LINE_SEP;
            }
            if (this.mDisplayMessages) {
                System.err.print(pText);
            }
            try {
                FileWriter fw = new FileWriter(this.mOutput, true);
                fw.write(pText);
                fw.flush();
                fw.close();
            }
            catch (IOException pE) {
                if (!this.mDisplayMessages) break block5;
                pE.printStackTrace();
            }
        }
        --this.mDisplayJavaVersion;
    }

    private String getTimeStamp() {
        return this.mFormat.format(new Date(System.currentTimeMillis())) + LINE_SEP;
    }

    public void setFormat(SimpleDateFormat pFormat) {
        this.mFormat = pFormat;
    }

    public void setHeader(String pHeader) {
        this.mHeader = pHeader;
    }

    public void setOutput(File pOutput) {
        this.mOutput = pOutput;
    }

    public void setDisplayJavaVersion(int pDisplayJavaVersion) {
        this.mDisplayJavaVersion = pDisplayJavaVersion;
    }

    public void setDisplayMessages(boolean pDisplayMessages) {
        this.mDisplayMessages = pDisplayMessages;
    }

    public File getOutput() {
        return this.mOutput;
    }
}

