/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mthread;

import de.maggicraft.mthread.AssemblyThread;
import org.jetbrains.annotations.NotNull;

public class AThread
extends Thread {
    private final AssemblyThread mMaster;
    private long mProcessingTime;

    public AThread(AssemblyThread pMaster, @NotNull String pName, int pPriority) {
        this.mMaster = pMaster;
        this.setName(pName);
        this.setPriority(pPriority);
    }

    @Override
    public void run() {
        int runId;
        while ((runId = this.mMaster.getNext()) != -1) {
            if (this.mMaster.showResults()) {
                long time = System.currentTimeMillis();
                if (this.mMaster.statsAll()) {
                    System.out.println(this.getName() + ":\tstarted");
                }
                this.mMaster.run(runId);
                long timeEnd = System.currentTimeMillis() - time;
                this.mProcessingTime += timeEnd;
                if (!this.mMaster.statsAll()) continue;
                System.out.println(this.getName() + ":\tended\t in " + (double)timeEnd / 1000.0 + 's');
                continue;
            }
            this.mMaster.run(runId);
        }
        this.mMaster.finished(this);
    }

    public long getProcessingTime() {
        return this.mProcessingTime;
    }
}

