/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mthread;

import de.maggicraft.mthread.AThread;
import de.maggicraft.mthread.IRun;
import org.jetbrains.annotations.NotNull;

public class AssemblyThread {
    private final IRun mRun;
    private Runnable mEnd;
    private final String mName;
    private double mProcessingTime;
    private long mTime;
    private final int mTill;
    private final int mThrQuantity;
    private final int mPriority;
    private int mCur;
    private int mFinished;
    private int mStats;

    public AssemblyThread(IRun pRun, int pTill, String pName, int pThrQuantity) {
        this(pRun, pTill, pName, pThrQuantity, 5, -1);
    }

    public AssemblyThread(IRun pRun, int pTill, String pName, int pThrQuantity, int pPriority, int pStats) {
        this.mRun = pRun;
        this.mName = pName;
        this.mTill = pTill;
        this.mThrQuantity = pThrQuantity;
        this.mPriority = pPriority;
        this.mStats = pStats;
        this.mCur = -1;
        this.mFinished = 0;
    }

    @NotNull
    public AssemblyThread start() {
        this.mTime = System.currentTimeMillis();
        for (int i = 0; i < this.mThrQuantity; ++i) {
            new AThread(this, this.mName + '-' + i, this.mPriority).start();
        }
        return this;
    }

    public synchronized void finished(@NotNull AThread pThread) {
        ++this.mFinished;
        if (this.showResults()) {
            if (this.statsFinished()) {
                System.out.println(this.mName + ":\tfinished [" + pThread.getName() + "] (" + this.mFinished + '/' + this.mThrQuantity + ")\tprocessing time: " + pThread.getProcessingTime() / 1000L);
            }
            this.mProcessingTime += (double)pThread.getProcessingTime();
        }
        if (this.mFinished == this.mThrQuantity) {
            if (this.showResults()) {
                double timeEnd = System.currentTimeMillis() - this.mTime;
                System.out.println("ended all threads in " + timeEnd / 1000.0 + " seconds, total processing time: " + this.mProcessingTime / 1000.0 + ", factor: " + (double)((int)(this.mProcessingTime / timeEnd * 100.0)) / 100.0);
            }
            if (this.mEnd != null) {
                this.mEnd.run();
            }
        }
    }

    public void run(int pRunId) {
        this.mRun.run(pRunId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNext() {
        int cur;
        AssemblyThread assemblyThread = this;
        synchronized (assemblyThread) {
            ++this.mCur;
            cur = this.mCur;
        }
        if (cur < this.mTill) {
            return cur;
        }
        return -1;
    }

    @NotNull
    public AssemblyThread endRun(Runnable pEnd) {
        this.mEnd = pEnd;
        return this;
    }

    @NotNull
    public AssemblyThread setStats(int pStats) {
        this.mStats = pStats;
        return this;
    }

    public boolean showResults() {
        return this.mStats >= 0;
    }

    public boolean statsFinished() {
        return this.mStats >= 1;
    }

    public boolean statsAll() {
        return this.mStats >= 2;
    }
}

