/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mthread;

import de.maggicraft.mlog.MLog;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MConsumer {
    @NotNull
    private final AtomicBoolean mRunning = new AtomicBoolean(false);
    private final BlockingQueue<Runnable> mTasks;
    @NotNull
    private final Thread mThread;

    public MConsumer(BlockingQueue<Runnable> pTasks) {
        this(pTasks, null, 5);
    }

    public MConsumer(BlockingQueue<Runnable> pTasks, @Nullable String pName, int pPriority) {
        this.mTasks = pTasks;
        this.mThread = new Thread(() -> {
            while (this.mRunning.get()) {
                try {
                    this.mTasks.take().run();
                }
                catch (InterruptedException pE) {
                    MLog.log(pE);
                }
            }
        });
        this.mThread.setPriority(pPriority);
        if (pName != null) {
            this.mThread.setName(pName);
        }
    }

    public void start() {
        if (this.mRunning.compareAndSet(false, true)) {
            this.mThread.start();
        }
    }

    public void stop() {
        this.mRunning.set(false);
    }
}

