/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mthread;

import de.maggicraft.mthread.MConsumer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class MConsumerBundle {
    @NotNull
    private final LinkedBlockingQueue<Runnable> mTasks = new LinkedBlockingQueue();
    @NotNull
    private final LinkedBlockingQueue<MConsumer> mConsumers = new LinkedBlockingQueue();
    @NotNull
    private final AtomicBoolean mIsRunning = new AtomicBoolean(true);
    private String mName;
    private int mPriority;

    public MConsumerBundle(int pConsumerQuantity) {
        this(pConsumerQuantity, "consumer", 5);
    }

    public MConsumerBundle(int pConsumerQuantity, String pName, int pPriority) {
        if (pPriority < 1 || pPriority > 10) {
            throw new IllegalArgumentException("priority not in bounds 1-10");
        }
        this.mPriority = pPriority;
        this.mName = pName;
        for (int i = 0; i < pConsumerQuantity; ++i) {
            this.addConsumer(new MConsumer(this.mTasks, this.mName + i, this.mPriority));
        }
    }

    public void addConsumer() {
        this.addConsumer(new MConsumer(this.mTasks, this.mName, this.mPriority));
    }

    public void addConsumer(@NotNull MConsumer pConsumer) {
        this.mConsumers.add(pConsumer);
        if (this.mIsRunning.get()) {
            pConsumer.start();
        }
    }

    public void addTask(Runnable pTask) {
        this.mTasks.add(pTask);
    }

    public void start() {
        this.mIsRunning.set(true);
        for (MConsumer consumer : this.mConsumers) {
            consumer.start();
        }
    }

    public void stop() {
        this.mIsRunning.set(false);
        for (MConsumer consumer : this.mConsumers) {
            consumer.stop();
        }
    }
}

