/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mthread;

import de.maggicraft.mthread.MAction;
import de.maggicraft.mthread.MasterThread;
import org.jetbrains.annotations.NotNull;

public class MThread
extends Thread {
    private final MasterThread mMaster;
    private long mProcessingTime;

    public MThread(MasterThread pMaster, @NotNull String pName, int pPriority) {
        this.mMaster = pMaster;
        this.setName(pName);
        this.setPriority(pPriority);
    }

    @Override
    public void run() {
        MAction action;
        while ((action = this.mMaster.getNext()) != null) {
            if (this.mMaster.statsResults()) {
                long time = System.currentTimeMillis();
                if (this.mMaster.statsAll()) {
                    System.out.println(this.getName() + ":\tstarted");
                }
                action.run();
                long timeEnd = System.currentTimeMillis() - time;
                this.mProcessingTime += timeEnd;
                if (!this.mMaster.statsAll()) continue;
                System.out.println(this.getName() + ":\tended in " + (double)timeEnd / 1000.0 + 's');
                continue;
            }
            action.run();
        }
        this.mMaster.finished(this);
    }

    public long getProcessingTime() {
        return this.mProcessingTime;
    }
}

