/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.mthread;

import de.maggicraft.mlog.MLog;
import de.maggicraft.mthread.MAction;
import de.maggicraft.mthread.MThread;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MasterThread {
    public static final int STATS_NONE = -1;
    public static final int STATS_RESULTS = 0;
    public static final int STATS_FINISHED = 1;
    public static final int STATS_ALL = 2;
    private List<MAction> mActions;
    private MAction mEndAction;
    private final String mName;
    private double mProcessingTime;
    private long mTime;
    private final int mThrQuantity;
    private final int mPriority;
    private int mCur;
    private int mFinished;
    private int mStats;

    public MasterThread(String pName, int pThrQuantity) {
        this(new ArrayList<MAction>(), pName, pThrQuantity, 5, -1);
    }

    public MasterThread(String pName, int pThrQuantity, int pPriority, int pStats) {
        this(new ArrayList<MAction>(), pName, pThrQuantity, pPriority, pStats);
    }

    public MasterThread(List<MAction> pActions, String pName, int pThrQuantity) {
        this(pActions, pName, pThrQuantity, 5, -1);
    }

    public MasterThread(List<MAction> pActions, String pName, int pThrQuantity, int pPriority, int pStats) {
        this.mActions = pActions;
        this.mName = pName;
        this.mThrQuantity = pThrQuantity;
        this.mPriority = pPriority;
        this.mStats = pStats;
        this.initValues();
    }

    public void initValues() {
        this.mCur = -1;
        this.mFinished = 0;
        for (int i = 0; i < this.mActions.size(); ++i) {
            if (this.mActions.get(i) != null) continue;
            throw new NullPointerException("action " + i + " is not initialized");
        }
    }

    @NotNull
    public MasterThread start() {
        this.mTime = System.currentTimeMillis();
        for (int i = 0; i < this.mThrQuantity; ++i) {
            new MThread(this, this.mName + '-' + i, this.mPriority).start();
        }
        return this;
    }

    public void waitToEnd() {
        while (this.mFinished != this.mThrQuantity) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException pE) {
                MLog.log(pE);
            }
        }
    }

    public synchronized void finished(@NotNull MThread pThread) {
        ++this.mFinished;
        if (this.statsResults()) {
            if (this.statsFinished()) {
                System.out.println(this.mName + ":\tfinished [" + pThread.getName() + "] (" + this.mFinished + '/' + this.mThrQuantity + ")\tprocessing time: " + pThread.getProcessingTime() / 1000L);
            }
            this.mProcessingTime += (double)pThread.getProcessingTime();
        }
        if (this.mFinished == this.mThrQuantity) {
            if (this.statsResults()) {
                double timeEnd = System.currentTimeMillis() - this.mTime;
                System.out.println("ended all threads in " + timeEnd / 1000.0 + " seconds, total processing time: " + this.mProcessingTime / 1000.0 + ", factor: " + (double)((int)(this.mProcessingTime / timeEnd * 100.0)) / 100.0);
            }
            this.end();
        }
    }

    public void end() {
        if (this.mEndAction != null) {
            this.mEndAction.run();
        }
    }

    public void add(Runnable pAction) {
        this.mActions.add(new MAction(pAction));
    }

    public void add(Runnable pAction, String pName) {
        this.mActions.add(new MAction(pAction, pName));
    }

    public void endAction(Runnable pAction) {
        this.mEndAction = new MAction(pAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public MAction getNext() {
        int cur;
        MasterThread masterThread = this;
        synchronized (masterThread) {
            ++this.mCur;
            cur = this.mCur;
        }
        if (cur < this.mActions.size()) {
            this.mActions.get(cur).setName("action " + cur);
            return this.mActions.get(cur);
        }
        return null;
    }

    @NotNull
    public MasterThread setStats(int pStats) {
        this.mStats = pStats;
        return this;
    }

    public void setActions(List<MAction> pActions) {
        this.mActions = pActions;
    }

    public boolean statsResults() {
        return this.mStats >= 0;
    }

    public boolean statsFinished() {
        return this.mStats >= 1;
    }

    public boolean statsAll() {
        return this.mStats >= 2;
    }

    public int getFinished() {
        return this.mFinished;
    }
}

