/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.server;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import team.creative.itemphysic.ItemPhysic;
import team.creative.itemphysic.common.CommonPhysic;

public class ItemPhysicServer {
    public static int tempDroppower = 1;
    public static final ThreadLocal<Fluid> fluid = new ThreadLocal();
    private static Method markVelocityChanged = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"func_70018_K", (Class[])new Class[0]);
    private static Field health = ObfuscationReflectionHelper.findField(ItemEntity.class, (String)"field_70291_e");
    private static Field fire = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_190534_ay");
    private static Field rand = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_70146_Z");
    private static Field age = ObfuscationReflectionHelper.findField(ItemEntity.class, (String)"field_70292_b");
    private static Method getFlag = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"func_70083_f", (Class[])new Class[]{Integer.TYPE});
    public static List<PlayerEntity> toCancel = new ArrayList<PlayerEntity>();

    public static void init(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ItemPhysicServer.class);
    }

    @SubscribeEvent
    public static void onDespawn(ItemExpireEvent event) {
        if (ItemPhysic.CONFIG.general.despawnItem == -1) {
            try {
                age.set(event.getEntityItem(), 1);
                event.setCanceled(true);
                event.setExtraLife(0);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onToos(ItemTossEvent event) {
        event.getEntityItem().func_213317_d(event.getEntityItem().func_213322_ci().func_186678_a((double)tempDroppower));
        tempDroppower = 1;
    }

    public static void updatePre(ItemEntity item) {
        double maxSpeedReduction;
        double speedreduction;
        ItemStack stack = item.func_92059_d();
        fluid.set(CommonPhysic.getFluid(item));
        if (fluid.get() == null) {
            if (!item.func_189652_ae()) {
                item.func_213317_d(item.func_213322_ci().func_72441_c(0.0, -0.04, 0.0));
            }
            return;
        }
        double density = (double)fluid.get().getAttributes().getDensity() / 1000.0;
        double speed = -1.0 / density * 0.01;
        if (ItemPhysic.CONFIG.general.swimmingItems.canPass(stack)) {
            speed = 0.1;
        }
        if ((speedreduction = (speed - item.func_213322_ci().field_72448_b) / 2.0) < -(maxSpeedReduction = 0.1)) {
            speedreduction = -maxSpeedReduction;
        }
        if (speedreduction > maxSpeedReduction) {
            speedreduction = maxSpeedReduction;
        }
        item.func_213317_d(item.func_213322_ci().func_72441_c(0.0, speedreduction, 0.0));
    }

    public static void updateBurn(ItemEntity item) {
        try {
            BlockState state;
            int i;
            Random rand = (Random)ItemPhysicServer.rand.get(item);
            if (item.field_70170_p.func_204610_c(item.func_233580_cy_()).func_206884_a((ITag)FluidTags.field_206960_b) && ItemPhysic.CONFIG.general.burningItems.canPass(item.func_92059_d())) {
                item.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + rand.nextFloat() * 0.4f);
                item.func_70106_y();
                for (i = 0; i < 100; ++i) {
                    item.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), (double)rand.nextFloat() * 0.1 - 0.05, 0.2 * rand.nextDouble(), (double)rand.nextFloat() * 0.1 - 0.05);
                }
            }
            if (item.func_70027_ad() && ItemPhysic.CONFIG.general.burningItems.canPass(item.func_92059_d())) {
                item.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + rand.nextFloat() * 0.4f);
                item.func_70106_y();
                for (i = 0; i < 100; ++i) {
                    item.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, item.func_226277_ct_(), item.func_226278_cu_(), item.func_226281_cx_(), (double)rand.nextFloat() * 0.1 - 0.05, 0.2 * rand.nextDouble(), (double)rand.nextFloat() * 0.1 - 0.05);
                }
            }
            if (ItemPhysic.CONFIG.general.enableIgniting && !item.field_70170_p.field_72995_K && item.func_233570_aj_() && Math.random() <= 0.1 && ItemPhysic.CONFIG.general.ignitingItems.canPass(item.func_92059_d()) && (state = item.field_70170_p.func_180495_p(item.func_233580_cy_().func_177977_b())).func_185904_a().func_76217_h() && item.field_70170_p.func_180495_p(item.func_233580_cy_()).func_185904_a().func_76222_j()) {
                item.field_70170_p.func_175656_a(item.func_233580_cy_(), Blocks.field_150480_ab.func_176223_P());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public static void update(ItemEntity item, float f) {
        if (fluid.get() == null) {
            item.func_213317_d(item.func_213322_ci().func_216372_d((double)f, 0.98, (double)f));
            if (item.func_233570_aj_()) {
                item.func_213317_d(item.func_213322_ci().func_216372_d(1.0, -0.5, 1.0));
            }
        } else {
            item.func_213317_d(item.func_213322_ci().func_216372_d(1.0 / ((double)fluid.get().getAttributes().getDensity() / 900.0), 1.0, 1.0 / ((double)fluid.get().getAttributes().getDensity() / 900.0)));
        }
        if (ItemPhysic.CONFIG.general.despawnItem != -1 && item.lifespan == 6000 && item.lifespan != ItemPhysic.CONFIG.general.despawnItem) {
            item.lifespan = ItemPhysic.CONFIG.general.despawnItem;
        }
    }

    public static void updateFallState(ItemEntity item, double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (onGroundIn && item.field_70143_R > 0.0f && ItemPhysic.CONFIG.general.fallSounds) {
            item.func_184185_a(SoundEvents.field_187548_af, Math.min(1.0f, item.field_70143_R / 10.0f), (float)Math.random() * 1.0f + 1.0f);
        }
    }

    public static boolean onCollideWithPlayer(ItemEntity item, PlayerEntity par1EntityPlayer) {
        if (ItemPhysic.CONFIG.pickup.customPickup && !par1EntityPlayer.func_226273_bm_() || !ItemPhysic.CONFIG.pickup.pickupWhenSneaking) {
            return true;
        }
        return item.field_70170_p.field_72995_K || item.func_174874_s();
    }

    public static void onCollideWithPlayer(ItemEntity entity, PlayerEntity player, boolean needsSneak) {
        if (ItemPhysic.CONFIG.pickup.customPickup && needsSneak && (!player.func_213453_ef() || !ItemPhysic.CONFIG.pickup.pickupWhenSneaking)) {
            return;
        }
        if (!entity.field_70170_p.field_72995_K) {
            if (!ItemPhysic.CONFIG.pickup.customPickup && entity.func_174874_s()) {
                return;
            }
            ItemStack itemstack = entity.func_92059_d();
            Item item = itemstack.func_77973_b();
            int i = itemstack.func_190916_E();
            int hook = ForgeEventFactory.onItemPickup((ItemEntity)entity, (PlayerEntity)player);
            if (hook < 0) {
                return;
            }
            ItemStack copy = itemstack.func_77946_l();
            if (!(entity.func_174874_s() && !ItemPhysic.CONFIG.pickup.customPickup || entity.func_200215_l() != null && entity.lifespan - entity.func_174872_o() > 200 && !entity.func_200215_l().equals(player.func_110124_au()) || hook != 1 && i > 0 && !player.field_71071_by.func_70441_a(itemstack))) {
                copy.func_190920_e(copy.func_190916_E() - entity.func_92059_d().func_190916_E());
                BasicEventHooks.firePlayerItemPickupEvent((PlayerEntity)player, (ItemEntity)entity, (ItemStack)copy);
                player.func_71001_a((Entity)entity, i);
                if (itemstack.func_190926_b()) {
                    player.func_71001_a((Entity)entity, i);
                    entity.func_70106_y();
                    itemstack.func_190920_e(i);
                }
                player.func_71064_a(Stats.field_199089_f.func_199076_b((Object)item), i);
            }
        }
    }

    public static boolean processInitialInteract(ItemEntity item, PlayerEntity player, Hand hand) {
        if (ItemPhysic.CONFIG.pickup.customPickup) {
            ItemPhysicServer.onCollideWithPlayer(item, player, false);
            return true;
        }
        return false;
    }

    public static boolean attackEntityFrom(ItemEntity item, DamageSource source, float amount) {
        if (item.field_70170_p.field_72995_K || item.func_70089_S()) {
            return false;
        }
        if (item.func_180431_b(source)) {
            return false;
        }
        if (!item.func_92059_d().func_190926_b() && ItemPhysic.CONFIG.general.undestroyableItems.canPass(item.func_92059_d())) {
            return false;
        }
        if (!item.func_92059_d().func_190926_b() && item.func_92059_d().func_77973_b() == Items.field_151156_bN && source.func_94541_c()) {
            return false;
        }
        if (source == DamageSource.field_76371_c | source == DamageSource.field_76370_b | source == DamageSource.field_76372_a && !ItemPhysic.CONFIG.general.burningItems.canPass(item.func_92059_d())) {
            return false;
        }
        if (source == DamageSource.field_76367_g) {
            return false;
        }
        try {
            markVelocityChanged.invoke((Object)item, new Object[0]);
            health.setInt(item, (int)((float)health.getInt(item) - amount));
            if (health.getInt(item) <= 0) {
                item.func_70106_y();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isItemBurning(ItemEntity item) {
        boolean flag = item.field_70170_p != null && item.field_70170_p.field_72995_K;
        try {
            if (item.func_230279_az_() || fire.getInt(item) <= 0 && (!flag || !((Boolean)getFlag.invoke((Object)item, 0)).booleanValue())) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ItemPhysic.CONFIG.general.burningItems.canPass(item.func_92059_d());
    }

    @SubscribeEvent
    public static void onUnload(WorldEvent.Unload event) {
        toCancel.removeIf(x -> x.field_70170_p == event.getWorld());
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        if ((event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.EntityInteract) && !event.getPlayer().field_70170_p.field_72995_K && toCancel.contains(event.getPlayer())) {
            toCancel.remove(event.getPlayer());
            event.setCanceled(true);
        }
    }
}

