/*
 * Decompiled with CFR 0.152.
 */
package com.fuffles.justanotherheadmod.client;

import com.fuffles.justanotherheadmod.client.AbstractHeadModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HorseHeadModel
extends AbstractHeadModel {
    private HorseEarStyle earStyle;
    private ModelRenderer horse;

    public HorseHeadModel(HorseEarStyle style, int textureWdth, int textureHght, float inflate) {
        super(textureWdth, textureHght, inflate);
        this.earStyle = style;
        this.modelInit(this.earStyle, this.textureOffsetX, this.textureOffsetY, Float.valueOf(this.inflate));
    }

    @Override
    public void changeTextureOffset(int offsetX, int offsetY) {
        this.modelInit(this.earStyle, offsetX, offsetY, Float.valueOf(this.inflate));
    }

    @Override
    public void changeInflation(float inflate) {
        this.modelInit(this.earStyle, this.textureOffsetX, this.textureOffsetY, Float.valueOf(inflate));
    }

    @Override
    protected void modelInit(Integer offsetX, Integer offsetY, Float inflate) {
        if (this.earStyle == null) {
            this.earStyle = HorseEarStyle.HORSE;
        }
        this.modelInit(this.earStyle, offsetX, offsetY, inflate);
    }

    private void modelInit(HorseEarStyle style, Integer offsetX, Integer offsetY, Float inflate) {
        this.textureOffsetX = offsetX;
        this.textureOffsetY = offsetY;
        this.inflate = inflate.floatValue();
        this.earStyle = style;
        this.main = null;
        this.main = new ModelRenderer((Model)this, 0, 0);
        this.main.func_78793_a(0.0f, 0.0f, 0.0f);
        this.horse = new ModelRenderer((Model)this, 0, 0);
        this.horse.func_78793_a(0.0f, 0.0f, 0.0f);
        this.horse.field_78795_f = 0.4363f;
        this.horse.func_217178_a("neck", -2.0f, -6.1f, -3.0f, 4, 8, 7, 0.0f, 0, 35);
        this.horse.func_217178_a("head", -3.0f, -11.1f, -3.0f, 6, 5, 7, 0.0f, 0, 13);
        this.horse.func_217178_a("muzzle", -2.0f, -11.1f, -8.0f, 4, 5, 5, 0.0f, 0, 25);
        this.horse.func_217178_a("mane", -1.0f, -11.1f, 4.001f, 2, 14, 2, 0.0f, 56, 36);
        if (style == HorseEarStyle.HORSE) {
            this.horse.func_217178_a("earR", -2.5f, -13.1f, 3.0f, 2, 2, 1, 0.0f, 19, 16);
            this.horse.func_217178_a("earL", 0.5f, -13.1f, 3.0f, 2, 2, 1, 0.0f, 19, 16);
        } else if (style == HorseEarStyle.DONKEY) {
            ModelRenderer earR = new ModelRenderer((Model)this, 0, 12);
            earR.func_228300_a_(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 1.0f);
            earR.func_78793_a(-1.25f, -10.0f, 4.0f);
            earR.field_78795_f = 0.2617994f;
            earR.field_78808_h = -0.2617994f;
            this.horse.func_78792_a(earR);
            ModelRenderer earL = new ModelRenderer((Model)this, 0, 12);
            earL.func_228300_a_(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 1.0f);
            earL.func_78793_a(1.25f, -10.0f, 4.0f);
            earL.field_78795_f = 0.2617994f;
            earL.field_78808_h = 0.2617994f;
            this.horse.func_78792_a(earL);
        }
        this.main.func_78792_a(this.horse);
    }

    public static enum HorseEarStyle {
        HORSE,
        DONKEY;

    }
}

