/*
 * Decompiled with CFR 0.152.
 */
package com.fuffles.justanotherheadmod.client;

import com.fuffles.justanotherheadmod.client.AbstractHeadModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SimpleAnimalHeadModel
extends AbstractHeadModel {
    private AnimalModelStyle animalStyle;

    public SimpleAnimalHeadModel(AnimalModelStyle style, int textureWdth, int textureHght, float inflate) {
        super(textureWdth, textureHght, inflate);
        this.animalStyle = style;
        this.modelInit(this.animalStyle, this.textureOffsetX, this.textureOffsetY, Float.valueOf(this.inflate));
    }

    @Override
    public void changeTextureOffset(int offsetX, int offsetY) {
        this.modelInit(this.animalStyle, offsetX, offsetY, Float.valueOf(this.inflate));
    }

    @Override
    public void changeInflation(float inflate) {
        this.modelInit(this.animalStyle, this.textureOffsetX, this.textureOffsetY, Float.valueOf(inflate));
    }

    @Override
    protected void modelInit(Integer offsetX, Integer offsetY, Float inflate) {
        if (this.animalStyle == null) {
            this.animalStyle = AnimalModelStyle.BEAR;
        }
        this.modelInit(this.animalStyle, offsetX, offsetY, inflate);
    }

    private void modelInit(AnimalModelStyle modelStyle, Integer offsetX, Integer offsetY, Float inflate) {
        this.textureOffsetX = offsetX;
        this.textureOffsetY = offsetY;
        this.inflate = inflate.floatValue();
        this.animalStyle = modelStyle;
        this.main = null;
        this.main = new ModelRenderer((Model)this, 0, 0);
        this.main.field_78809_i = false;
        this.main.func_78793_a(0.0f, 0.0f, 0.0f);
        switch (modelStyle) {
            case BEAR: {
                this.main.func_217178_a("7^3", -3.5f, -7.0f, -3.5f, 7, 7, 7, inflate.floatValue(), offsetX.intValue(), offsetY.intValue());
                this.main.func_217178_a("muzzle", -2.5f, -3.0f, -6.0f, 5, 3, 3, inflate.floatValue(), offsetX.intValue(), offsetY + 44);
                this.main.func_217178_a("earR", -4.5f, -8.0f, -1.0f, 2, 2, 1, inflate.floatValue(), offsetX + 26, offsetY.intValue());
                this.main.field_78809_i = true;
                this.main.func_217178_a("earL", 2.5f, -8.0f, -1.0f, 2, 2, 1, inflate.floatValue(), offsetX + 26, offsetY.intValue());
                break;
            }
            case COW: {
                this.main.func_217178_a("8x8x6", -4.0f, -8.0f, -3.0f, 8, 8, 6, inflate.floatValue(), offsetX.intValue(), offsetY.intValue());
                this.main.func_217178_a("hornR", -5.0f, -9.0f, -1.0f, 1, 3, 1, inflate.floatValue(), offsetX + 22, offsetY.intValue());
                this.main.func_217178_a("hornL", 4.0f, -9.0f, -1.0f, 1, 3, 1, inflate.floatValue(), offsetX + 22, offsetY.intValue());
                break;
            }
            case DOLPHIN: {
                this.main.func_217178_a("8x7x6", -4.0f, -7.0f, -4.0f, 8, 7, 6, inflate.floatValue(), offsetX.intValue(), offsetY.intValue());
                this.main.func_217178_a("bodybit", -4.0f, -7.0f, 2.0f, 8, 7, 2, inflate.floatValue(), offsetX + 33, offsetY + 11);
                this.main.func_217178_a("beak", -1.0f, -2.0f, -8.0f, 2, 2, 4, inflate.floatValue(), offsetX.intValue(), offsetY + 13);
                break;
            }
            case FOX: {
                this.main.func_217178_a("8x6^2", -4.0f, -6.0f, -3.0f, 8, 6, 6, inflate.floatValue(), offsetX + 1, offsetY + 5);
                this.main.func_217178_a("muzzle", -2.0f, -2.0f, -6.0f, 4, 2, 3, inflate.floatValue(), offsetX + 6, offsetY + 18);
                this.main.func_217178_a("earR", -4.0f, -8.0f, -2.0f, 2, 2, 1, inflate.floatValue(), offsetX + 8, offsetY + 1);
                this.main.func_217178_a("earL", 2.0f, -8.0f, -2.0f, 2, 2, 1, inflate.floatValue(), offsetX + 15, offsetY + 1);
                break;
            }
            case LLAMA: {
                this.main.func_217178_a("8x10x6", -4.0f, -10.0f, -3.0f, 8, 10, 6, inflate.floatValue(), offsetX.intValue(), offsetY + 14);
                this.main.func_217178_a("muzzle", -2.0f, -8.0f, -7.0f, 4, 4, 5, inflate.floatValue(), offsetX + 4, offsetY + 4);
                this.main.func_217178_a("earR", -4.0f, -13.0f, -1.0f, 3, 3, 2, inflate.floatValue(), offsetX + 17, offsetY.intValue());
                this.main.field_78809_i = true;
                this.main.func_217178_a("earL", 1.0f, -13.0f, -1.0f, 3, 3, 2, inflate.floatValue(), offsetX + 17, offsetY.intValue());
                break;
            }
            case PANDA: {
                this.main.func_217178_a("13x10x9", -6.5f, -10.0f, -4.5f, 13, 10, 9, inflate.floatValue(), offsetX.intValue(), offsetY + 6);
                this.main.func_217178_a("muzzle", -3.5f, -5.0f, -6.5f, 7, 5, 2, inflate.floatValue(), offsetX + 45, offsetY + 16);
                this.main.func_217178_a("earR", -8.5f, -13.0f, -1.5f, 5, 4, 1, inflate.floatValue(), offsetX + 52, offsetY + 25);
                this.main.field_78809_i = true;
                this.main.func_217178_a("earL", 3.5f, -13.0f, -1.5f, 5, 4, 1, inflate.floatValue(), offsetX + 52, offsetY + 25);
                break;
            }
            case SHEEP: {
                this.main.func_217178_a("6^2x8", -3.0f, -6.6f, -5.0f, 6, 6, 8, inflate.floatValue(), offsetX.intValue(), offsetY.intValue());
                break;
            }
            case SHEEP_WOOL: {
                this.main.func_217178_a("6^3", -3.0f, -6.6f, -3.0f, 6, 6, 6, inflate.floatValue() + 0.6f, offsetX.intValue(), offsetY.intValue());
                break;
            }
            case WOLF: {
                this.main.func_217178_a("6^2x4", -3.0f, -6.0f, -2.0f, 6, 6, 4, inflate.floatValue(), offsetX.intValue(), offsetY.intValue());
                this.main.func_217178_a("muzzle", -1.5f, -3.0f, -5.0f, 3, 3, 4, inflate.floatValue(), offsetX.intValue(), offsetY + 10);
                this.main.func_217178_a("earR", -3.0f, -8.0f, 0.0f, 2, 2, 1, inflate.floatValue(), offsetX + 16, offsetY + 14);
                this.main.field_78809_i = true;
                this.main.func_217178_a("earL", 1.0f, -8.0f, 0.0f, 2, 2, 1, inflate.floatValue(), offsetX + 16, offsetY + 14);
                break;
            }
        }
    }

    public static enum AnimalModelStyle {
        BEAR,
        COW,
        DOLPHIN,
        FOX,
        LLAMA,
        PANDA,
        SHEEP,
        SHEEP_WOOL,
        WOLF;

    }
}

