/*
 * Decompiled with CFR 0.152.
 */
package com.fuffles.justanotherheadmod.client.render;

import com.fuffles.justanotherheadmod.client.AbstractHeadModel;
import com.fuffles.justanotherheadmod.common.block.AnotherAbstractSkullBlock;
import com.fuffles.justanotherheadmod.common.block.AnotherWallSkullBlock;
import com.fuffles.justanotherheadmod.common.tileentity.AnotherSkullTileEntity;
import com.fuffles.justanotherheadmod.proxy.CommonProxy;
import com.fuffles.justanotherheadmod.util.RenderHelper;
import com.fuffles.justanotherheadmod.util.SkullData;
import com.fuffles.justanotherheadmod.util.VillagerMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnotherSkullTileEntityRenderer
extends TileEntityRenderer<AnotherSkullTileEntity> {
    public AnotherSkullTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(AnotherSkullTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float animTick = tileEntityIn.getAnimationProgress(partialTicks);
        BlockState blockstate = tileEntityIn.func_195044_w();
        boolean onWall = blockstate.func_177230_c() instanceof AnotherWallSkullBlock;
        Direction dir = onWall ? (Direction)blockstate.func_177229_b((IProperty)AnotherWallSkullBlock.FACING) : null;
        float rot = 22.5f * (float)(onWall ? (2 + dir.func_176736_b()) * 4 : (Integer)blockstate.func_177229_b((IProperty)SkullBlock.field_196294_a));
        AnotherSkullTileEntityRenderer.renderInit(dir, rot, ((AnotherAbstractSkullBlock)blockstate.func_177230_c()).getLivingEntityType(), animTick, matrixStackIn, bufferIn, combinedLightIn, tileEntityIn.getVariants(), tileEntityIn.getTints());
    }

    public static void renderInit(@Nullable Direction dir, float rot, Class<? extends LivingEntity> entityType, float animTick, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, @Nullable Map<Integer, String> layers, @Nullable Map<Integer, ListNBT> tints) {
        SkullData data = CommonProxy.GLOBAL_SKULL_DATA.get(entityType);
        if (data != null) {
            Float[] rgba;
            ResourceLocation texture;
            Map map;
            RenderHelper helper;
            RenderType type;
            AbstractHeadModel model0 = (AbstractHeadModel)((Object)data.getResource(SkullData.SkullResourceType.L0));
            AbstractHeadModel model1 = (AbstractHeadModel)((Object)data.getResource(SkullData.SkullResourceType.L1));
            AbstractHeadModel model2 = (AbstractHeadModel)((Object)data.getResource(SkullData.SkullResourceType.L2));
            double nudge = data.getWallNudge();
            matrixStackIn.func_227860_a_();
            if (dir == null) {
                matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
            } else {
                switch (dir) {
                    case NORTH: {
                        matrixStackIn.func_227861_a_(0.5, 0.25, (double)0.74f + nudge);
                        break;
                    }
                    case SOUTH: {
                        matrixStackIn.func_227861_a_(0.5, 0.25, (double)0.26f - nudge);
                        break;
                    }
                    case WEST: {
                        matrixStackIn.func_227861_a_((double)0.74f + nudge, 0.25, 0.5);
                        break;
                    }
                    case EAST: {
                        matrixStackIn.func_227861_a_((double)0.26f - nudge, 0.25, 0.5);
                        break;
                    }
                    default: {
                        matrixStackIn.func_227861_a_(0.5, 0.25, (double)0.74f + nudge);
                    }
                }
            }
            matrixStackIn.func_227862_a_(-1.0f, -1.0f, 1.0f);
            if (model0 != null) {
                type = null;
                helper = null;
                if (data.getResource(SkullData.SkullResourceType.R0) instanceof RenderHelper) {
                    helper = (RenderHelper)data.getResource(SkullData.SkullResourceType.R0);
                } else if (data.getResource(SkullData.SkullResourceType.R0) instanceof Map) {
                    map = (Map)data.getResource(SkullData.SkullResourceType.R0);
                    helper = layers != null && layers.containsKey(0) ? (RenderHelper)map.get(layers.get(0)) : (RenderHelper)map.values().toArray()[0];
                }
                if (helper != null) {
                    texture = helper.getTexture();
                    switch (helper.getRenderType()) {
                        case ENERGY_SWIRL: {
                            type = RenderType.func_228636_a_((ResourceLocation)texture, (float)(animTick * 0.01f), (float)(animTick * 0.01f));
                            break;
                        }
                        case EYES: {
                            type = RenderType.func_228652_i_((ResourceLocation)texture);
                            break;
                        }
                        default: {
                            type = RenderType.func_228642_d_((ResourceLocation)texture);
                        }
                    }
                    if (type != null) {
                        rgba = new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
                        if (tints != null && tints.get(0) != null) {
                            rgba[0] = Float.valueOf(((FloatNBT)tints.get(0).toArray()[0]).func_150288_h());
                            rgba[1] = Float.valueOf(((FloatNBT)tints.get(0).toArray()[1]).func_150288_h());
                            rgba[2] = Float.valueOf(((FloatNBT)tints.get(0).toArray()[2]).func_150288_h());
                        }
                        model0.adjustSkull(animTick, rot, 0.0f);
                        model0.func_225598_a_(matrixStackIn, bufferIn.getBuffer(type), combinedLightIn, OverlayTexture.field_229196_a_, rgba[0].floatValue(), rgba[1].floatValue(), rgba[2].floatValue(), rgba[3].floatValue());
                    }
                }
            }
            if (model1 != null) {
                type = null;
                helper = null;
                if (data.getResource(SkullData.SkullResourceType.R1) instanceof RenderHelper) {
                    helper = (RenderHelper)data.getResource(SkullData.SkullResourceType.R1);
                } else if (data.getResource(SkullData.SkullResourceType.R1) instanceof Map) {
                    map = (Map)data.getResource(SkullData.SkullResourceType.R1);
                    boolean flag = true;
                    if (layers != null && layers.containsKey(1) && layers.containsKey(2)) {
                        if (entityType == VillagerEntity.class) {
                            flag = VillagerMap.villagerMap.get(layers.get(1)) != null ? VillagerMap.villagerMap.get(layers.get(1)).doDisplayFor(layers.get(2)) : true;
                        } else if (entityType == ZombieVillagerEntity.class) {
                            flag = VillagerMap.zombillagerMap.doDisplayFor(layers.get(2));
                        }
                    }
                    if (flag) {
                        helper = layers != null && layers.containsKey(1) ? (RenderHelper)map.get(layers.get(1)) : (layers != null && layers.containsKey(0) ? (RenderHelper)map.get(layers.get(0)) : (RenderHelper)map.values().toArray()[0]);
                    }
                }
                if (helper != null) {
                    texture = helper.getTexture();
                    switch (helper.getRenderType()) {
                        case ENERGY_SWIRL: {
                            type = RenderType.func_228636_a_((ResourceLocation)texture, (float)(animTick * 0.01f), (float)(animTick * 0.01f));
                            break;
                        }
                        case EYES: {
                            type = RenderType.func_228652_i_((ResourceLocation)texture);
                            break;
                        }
                        default: {
                            type = RenderType.func_228642_d_((ResourceLocation)texture);
                        }
                    }
                    if (type != null) {
                        rgba = new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
                        if (tints != null && tints.get(1) != null) {
                            rgba[0] = Float.valueOf(((FloatNBT)tints.get(1).toArray()[0]).func_150288_h());
                            rgba[1] = Float.valueOf(((FloatNBT)tints.get(1).toArray()[1]).func_150288_h());
                            rgba[2] = Float.valueOf(((FloatNBT)tints.get(1).toArray()[2]).func_150288_h());
                        }
                        if (helper.getRenderType().equals((Object)RenderHelper.RenderHelperType.ENERGY_SWIRL)) {
                            Float[] floatArray = rgba;
                            Float.valueOf(floatArray[0].floatValue() * 0.5f);
                            floatArray = rgba;
                            Float.valueOf(floatArray[1].floatValue() * 0.5f);
                            floatArray = rgba;
                            Float.valueOf(floatArray[2].floatValue() * 0.5f);
                        }
                        model1.adjustSkull(animTick, rot, 0.0f);
                        model1.func_225598_a_(matrixStackIn, bufferIn.getBuffer(type), combinedLightIn, OverlayTexture.field_229196_a_, rgba[0].floatValue(), rgba[1].floatValue(), rgba[2].floatValue(), rgba[3].floatValue());
                    }
                }
            }
            if (model2 != null) {
                type = null;
                helper = null;
                if (data.getResource(SkullData.SkullResourceType.R2) instanceof RenderHelper) {
                    helper = (RenderHelper)data.getResource(SkullData.SkullResourceType.R2);
                } else if (data.getResource(SkullData.SkullResourceType.R2) instanceof Map) {
                    map = (Map)data.getResource(SkullData.SkullResourceType.R2);
                    helper = layers != null && layers.containsKey(2) ? (RenderHelper)map.get(layers.get(2)) : (RenderHelper)map.values().toArray()[0];
                }
                if (helper != null) {
                    texture = helper.getTexture();
                    switch (helper.getRenderType()) {
                        case ENERGY_SWIRL: {
                            type = RenderType.func_228636_a_((ResourceLocation)texture, (float)(animTick * 0.01f), (float)(animTick * 0.01f));
                            break;
                        }
                        case EYES: {
                            type = RenderType.func_228652_i_((ResourceLocation)texture);
                            break;
                        }
                        default: {
                            type = RenderType.func_228642_d_((ResourceLocation)texture);
                        }
                    }
                    if (type != null) {
                        rgba = new Float[]{Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f)};
                        if (tints != null && tints.get(2) != null) {
                            rgba[0] = Float.valueOf(((FloatNBT)tints.get(2).toArray()[0]).func_150288_h());
                            rgba[1] = Float.valueOf(((FloatNBT)tints.get(2).toArray()[1]).func_150288_h());
                            rgba[2] = Float.valueOf(((FloatNBT)tints.get(2).toArray()[2]).func_150288_h());
                        }
                        model2.adjustSkull(animTick, rot, 0.0f);
                        model2.func_225598_a_(matrixStackIn, bufferIn.getBuffer(type), combinedLightIn, OverlayTexture.field_229196_a_, rgba[0].floatValue(), rgba[1].floatValue(), rgba[2].floatValue(), rgba[3].floatValue());
                    }
                }
            }
            matrixStackIn.func_227865_b_();
        }
    }
}

