/*
 * Decompiled with CFR 0.152.
 */
package com.fuffles.justanotherheadmod.common.block;

import com.fuffles.justanotherheadmod.registry.RegisterVanillaPillars;
import com.fuffles.justanotherheadmod.util.PillarBlockStateType;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PillarBlock
extends Block
implements IWaterLoggable {
    public static final EnumProperty<PillarBlockStateType> TYPE = EnumProperty.func_177709_a((String)"type", PillarBlockStateType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape collumnShape = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape topSingleShape = Block.func_208617_a((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape topShape = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape botShape = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape SINGLE_AABB = VoxelShapes.func_216384_a((VoxelShape)topSingleShape, (VoxelShape[])new VoxelShape[]{collumnShape, botShape});
    private static final VoxelShape TOP_AABB = VoxelShapes.func_197872_a((VoxelShape)topShape, (VoxelShape)collumnShape);
    private static final VoxelShape MID_AABB = VoxelShapes.func_216384_a((VoxelShape)collumnShape, (VoxelShape[])new VoxelShape[0]);
    private static final VoxelShape BOT_AABB = VoxelShapes.func_197872_a((VoxelShape)collumnShape, (VoxelShape)botShape);

    public PillarBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)PillarBlockStateType.SINGLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        PillarBlockStateType pillarStyle = (PillarBlockStateType)((Object)state.func_177229_b(TYPE));
        switch (pillarStyle) {
            case TOP: {
                return TOP_AABB;
            }
            case MIDDLE: {
                return MID_AABB;
            }
            case BOTTOM: {
                return BOT_AABB;
            }
        }
        return SINGLE_AABB;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)PillarBlockStateType.SINGLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        boolean pillarAboveFlag = worldIn.func_180495_p(currentPos.func_177984_a()).func_177230_c() instanceof PillarBlock;
        boolean pillarBelowFlag = worldIn.func_180495_p(currentPos.func_177977_b()).func_177230_c() instanceof PillarBlock;
        return (BlockState)stateIn.func_206870_a(TYPE, (Comparable)((Object)PillarBlockStateType.valueOf(pillarAboveFlag && pillarBelowFlag ? "MIDDLE" : (pillarAboveFlag && !pillarBelowFlag ? "BOTTOM" : (!pillarAboveFlag && pillarBelowFlag ? "TOP" : "SINGLE")))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_225543_m_(BlockState blockState) {
        return blockState.func_177230_c() == RegisterVanillaPillars.VANILLA_PILLARS.get(RegisterVanillaPillars.VanillaPillar.NETHER_BRICK);
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }
}

