/*
 * Decompiled with CFR 0.152.
 */
package com.fuffles.justanotherheadmod.common.item;

import com.fuffles.justanotherheadmod.common.block.AnotherAbstractSkullBlock;
import com.fuffles.justanotherheadmod.common.block.AnotherSkullBlock;
import com.fuffles.justanotherheadmod.common.block.AnotherWallSkullBlock;
import com.fuffles.justanotherheadmod.proxy.CommonProxy;
import com.fuffles.justanotherheadmod.registry.RegisterSkulls;
import com.fuffles.justanotherheadmod.util.SkullModifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.WallOrFloorItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeItem;

public class AnotherSkullItem
extends WallOrFloorItem
implements IForgeItem {
    private AnotherSkullBlock mySkullType;
    public static final IDispenseItemBehavior DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            return AnotherSkullItem.canBeDispensedOnTheHead(source, stack) ? stack : super.func_82487_b(source, stack);
        }
    };
    private int WITHER_SKEL_INDEX = 50;
    private int PLAYER_INDEX = 100;
    private int ZOMBIE_INDEX = 150;
    private int CREEPER_INDEX = 200;
    private int DRAGON_INDEX = 250;
    private Map<Integer, ItemStack> skullIndex = new HashMap<Integer, ItemStack>();

    public AnotherSkullItem(AnotherSkullBlock floorBlock, AnotherWallSkullBlock wallBlock, Item.Properties properties) {
        super((Block)floorBlock, (Block)wallBlock, properties);
        this.mySkullType = floorBlock;
    }

    public static boolean canBeDispensedOnTheHead(IBlockSource source, ItemStack stack) {
        BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a));
        List list = source.func_197524_h().func_175647_a(LivingEntity.class, new AxisAlignedBB(blockpos), EntityPredicates.field_180132_d.and(new EntityPredicates.ArmoredMob(stack)));
        if (list.isEmpty()) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)list.get(0);
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d((ItemStack)stack);
        ItemStack itemstack = stack.func_77979_a(1);
        livingEntity.func_184201_a(equipmentslottype, itemstack);
        if (livingEntity instanceof MobEntity) {
            ((MobEntity)livingEntity).func_184642_a(equipmentslottype, 2.0f);
            ((MobEntity)livingEntity).func_110163_bv();
        }
        return true;
    }

    private static CompoundNBT baseNBT(ItemStack stack) {
        CompoundNBT nbts = stack.func_77978_p();
        if (nbts == null) {
            nbts = new CompoundNBT();
            stack.func_77982_d(nbts);
        }
        if (!nbts.func_74764_b("Variant")) {
            nbts.func_218657_a("Variant", (INBT)new CompoundNBT());
        }
        return nbts;
    }

    public static void setVariant(ItemStack stack, int layer, String value) {
        CompoundNBT nbts = AnotherSkullItem.baseNBT(stack);
        if (layer > -1 && layer < 3) {
            nbts.func_74775_l("Variant").func_74778_a(Integer.toString(layer), value);
        }
        stack.func_77982_d(nbts);
    }

    private static ListNBT FloatList(Float ... numbers) {
        ListNBT listnbt = new ListNBT();
        Float[] floatArray = numbers;
        int n = floatArray.length;
        for (int i = 0; i < n; ++i) {
            float f = floatArray[i].floatValue();
            listnbt.add((Object)FloatNBT.func_229689_a_((float)f));
        }
        return listnbt;
    }

    public static void setTint(ItemStack stack, int layer, Float[] floats) {
        CompoundNBT nbts = AnotherSkullItem.baseNBT(stack);
        if (!nbts.func_74775_l("Variant").func_74764_b("Tint")) {
            nbts.func_74775_l("Variant").func_218657_a("Tint", (INBT)new CompoundNBT());
        }
        if (layer > -1 && layer < 3) {
            nbts.func_74775_l("Variant").func_74775_l("Tint").func_218657_a(Integer.toString(layer), (INBT)AnotherSkullItem.FloatList(floats));
        }
        stack.func_77982_d(nbts);
    }

    public EquipmentSlotType getEquipmentSlot(ItemStack stack) {
        Class<? extends LivingEntity> type = ((AnotherAbstractSkullBlock)((BlockItem)stack.func_77973_b()).func_179223_d()).getLivingEntityType();
        if (type == CowEntity.class || type == DolphinEntity.class || type == DonkeyEntity.class || type == FoxEntity.class || type == HorseEntity.class || type == LlamaEntity.class || type == MooshroomEntity.class || type == MuleEntity.class || type == SkeletonHorseEntity.class || type == WolfEntity.class || type == ZombieHorseEntity.class) {
            return null;
        }
        return EquipmentSlotType.HEAD;
    }

    private static String makeFancy(String str) {
        String strng = null;
        strng = str.contains("minecraft:") ? str.replace("minecraft:", "") : (str.contains("_") ? str.replace("_", " ") : str);
        char[] character_array = new char[strng.length()];
        for (int i = 0; i < strng.length(); ++i) {
            char character = strng.charAt(i);
            if (i == 0 || i > 0 && strng.charAt(i - 1) == ' ') {
                character = Character.toUpperCase(strng.charAt(i));
            }
            character_array[i] = character;
        }
        return new String(character_array);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbts = stack.func_77978_p();
        if (nbts != null && nbts.func_74764_b("Variant")) {
            for (int layer = 0; layer < 3; ++layer) {
                if (!nbts.func_74775_l("Variant").func_74764_b(Integer.toString(layer))) continue;
                tooltip.add(new StringTextComponent(AnotherSkullItem.makeFancy(nbts.func_74775_l("Variant").func_74779_i(Integer.toString(layer)))).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
            }
            if (nbts.func_74775_l("Variant").func_74764_b("Tint")) {
                tooltip.add(new StringTextComponent("Tinted").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY).func_150217_b(Boolean.valueOf(true))));
            }
        }
    }

    private int getSkullIndex(NonNullList<ItemStack> items, Item item) {
        int i = 0;
        for (ItemStack stack : items) {
            if (stack.func_77973_b() != item) continue;
            i = items.indexOf((Object)stack);
        }
        return i;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group) && this.mySkullType.getLivingEntityType() == BlazeEntity.class) {
            int unsetIndex = 300;
            for (Class<? extends LivingEntity> ent : CommonProxy.GLOBAL_SKULL_DATA.keySet()) {
                Object index;
                Object obj_i = CommonProxy.GLOBAL_SKULL_DATA.get(ent).getCreativeListIndex();
                ItemStack skullItem = new ItemStack((IItemProvider)RegisterSkulls.SKULL_ITEMS.get(ent));
                if (obj_i instanceof Integer[]) {
                    index = (Integer[])CommonProxy.GLOBAL_SKULL_DATA.get(ent).getCreativeListIndex();
                    for (int i = 0; i < ((Integer[])index).length; ++i) {
                        skullItem = new ItemStack((IItemProvider)RegisterSkulls.SKULL_ITEMS.get(ent));
                        SkullModifier mod = CommonProxy.GLOBAL_SKULL_DATA.get(ent).getCreativeItemVariants()[i];
                        if (mod != null) {
                            for (int layer = 0; layer < 3; ++layer) {
                                if (mod.getVariantName(layer) != null) {
                                    AnotherSkullItem.setVariant(skullItem, layer, mod.getVariantName(layer));
                                }
                                if (mod.getTintArray(layer) == null) continue;
                                AnotherSkullItem.setTint(skullItem, layer, mod.getTintArray(layer));
                            }
                        }
                        this.skullIndex.put((Integer)index[i], skullItem);
                    }
                    continue;
                }
                if (!(obj_i instanceof Integer)) continue;
                index = (Integer)CommonProxy.GLOBAL_SKULL_DATA.get(ent).getCreativeListIndex();
                if (CommonProxy.GLOBAL_SKULL_DATA.get(ent).getCreativeItemVariants() != null) {
                    SkullModifier mod = CommonProxy.GLOBAL_SKULL_DATA.get(ent).getCreativeItemVariants()[0];
                    for (int layer = 0; layer < 3; ++layer) {
                        if (mod.getVariantName(layer) != null) {
                            AnotherSkullItem.setVariant(skullItem, layer, mod.getVariantName(layer));
                        }
                        if (mod.getTintArray(layer) == null) continue;
                        AnotherSkullItem.setTint(skullItem, layer, mod.getTintArray(layer));
                    }
                }
                if ((Integer)index > 0 && !this.skullIndex.containsKey(index)) {
                    this.skullIndex.put((Integer)index, skullItem);
                    continue;
                }
                if ((Integer)index >= 0 || ((Integer)index).equals(-999)) continue;
                this.skullIndex.put(unsetIndex, skullItem);
                ++unsetIndex;
            }
            int s = 0;
            int w = 0;
            int p = 0;
            int z = 0;
            int c = 0;
            int d = 0;
            for (int checkIndex = 0; checkIndex < 500; ++checkIndex) {
                if (!this.skullIndex.containsKey(checkIndex)) continue;
                ItemStack item_stack = this.skullIndex.get(checkIndex);
                if (checkIndex < this.WITHER_SKEL_INDEX) {
                    items.add(this.getSkullIndex(items, Items.field_196182_dv) + ++s, (Object)item_stack);
                    continue;
                }
                if (checkIndex < this.PLAYER_INDEX) {
                    items.add(this.getSkullIndex(items, Items.field_196183_dw) + ++w, (Object)item_stack);
                    continue;
                }
                if (checkIndex < this.ZOMBIE_INDEX) {
                    items.add(this.getSkullIndex(items, Items.field_196184_dx) + ++p, (Object)item_stack);
                    continue;
                }
                if (checkIndex < this.CREEPER_INDEX) {
                    items.add(this.getSkullIndex(items, Items.field_196186_dz) + ++z, (Object)item_stack);
                    continue;
                }
                if (checkIndex < this.DRAGON_INDEX) {
                    items.add(this.getSkullIndex(items, Items.field_196185_dy) + ++c, (Object)item_stack);
                    continue;
                }
                items.add(this.getSkullIndex(items, Items.field_196151_dA) + ++d, (Object)this.skullIndex.get(checkIndex));
            }
        }
    }
}

