/*
 * Decompiled with CFR 0.152.
 */
package com.fuffles.justanotherheadmod.common.tileentity;

import com.fuffles.justanotherheadmod.common.block.AnotherAbstractSkullBlock;
import com.fuffles.justanotherheadmod.common.block.AnotherWallSkullBlock;
import com.fuffles.justanotherheadmod.proxy.CommonProxy;
import com.fuffles.justanotherheadmod.registry.RegisterSkullTileEnt;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AnotherSkullTileEntity
extends TileEntity
implements ITickableTileEntity {
    private Map<Integer, String> inheritedLayers = new HashMap<Integer, String>();
    private Map<Integer, ListNBT> inheritedTints = new HashMap<Integer, ListNBT>();
    private float animTick;

    public AnotherSkullTileEntity() {
        super(RegisterSkullTileEnt.ANOTHER_SKULL_TILE_ENT);
    }

    public void setVariant(int layer, String value) {
        if (this.inheritedLayers.containsKey(layer)) {
            this.inheritedLayers.replace(layer, value);
        } else {
            this.inheritedLayers.put(layer, value);
        }
    }

    @Nullable
    public String getVariant(int layer) {
        if (this.inheritedLayers.containsKey(layer)) {
            return this.inheritedLayers.get(layer);
        }
        return null;
    }

    @Nullable
    public Map<Integer, String> getVariants() {
        if (!this.inheritedLayers.isEmpty()) {
            return this.inheritedLayers;
        }
        return null;
    }

    public void setTint(int layer, ListNBT tint) {
        if (this.inheritedTints.containsKey(layer)) {
            this.inheritedTints.replace(layer, tint);
        } else {
            this.inheritedTints.put(layer, tint);
        }
    }

    @Nullable
    public Float[] getTint(int layer) {
        if (this.inheritedTints.containsKey(layer)) {
            Object[] rgba = new Float[this.inheritedTints.get(layer).size()];
            rgba = (Float[])this.inheritedTints.get(layer).toArray(rgba);
            return rgba;
        }
        return null;
    }

    @Nullable
    public Map<Integer, ListNBT> getTints() {
        if (!this.inheritedTints.isEmpty()) {
            return this.inheritedTints;
        }
        return null;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        int layer;
        super.func_189515_b(compound);
        compound.func_218657_a("Variant", (INBT)new CompoundNBT());
        if (this.inheritedLayers.values().size() > 0) {
            for (layer = 0; layer < 3; ++layer) {
                if (!this.inheritedLayers.containsKey(layer)) continue;
                compound.func_74775_l("Variant").func_74778_a(Integer.toString(layer), this.inheritedLayers.get(layer));
            }
        }
        if (this.inheritedTints.values().size() > 0) {
            if (!compound.func_74775_l("Variant").func_74764_b("Tint")) {
                compound.func_74775_l("Variant").func_218657_a("Tint", (INBT)new CompoundNBT());
            }
            for (layer = 0; layer < 3; ++layer) {
                if (!this.inheritedTints.containsKey(layer)) continue;
                compound.func_74775_l("Variant").func_74775_l("Tint").func_218657_a(Integer.toString(layer), (INBT)this.inheritedTints.get(layer));
            }
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Variant")) {
            int layer;
            for (layer = 0; layer < 3; ++layer) {
                if (!compound.func_74775_l("Variant").func_74764_b(Integer.toString(layer))) continue;
                this.setVariant(layer, compound.func_74775_l("Variant").func_74779_i(Integer.toString(layer)));
            }
            if (compound.func_74775_l("Variant").func_74764_b("Tint")) {
                for (layer = 0; layer < 3; ++layer) {
                    if (!compound.func_74775_l("Variant").func_74775_l("Tint").func_74764_b(Integer.toString(layer))) continue;
                    this.setTint(layer, (ListNBT)compound.func_74775_l("Variant").func_74775_l("Tint").func_74781_a(Integer.toString(layer)));
                }
            }
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem(BlockState p_190615_1_) {
        CompoundNBT nbts;
        int layer;
        ItemStack skullItem = new ItemStack((IItemProvider)this.func_195044_w().func_177230_c().func_199767_j());
        CompoundNBT variant_nbts = new CompoundNBT();
        if (!this.inheritedLayers.isEmpty()) {
            for (layer = 0; layer < 3; ++layer) {
                if (!this.inheritedLayers.containsKey(layer)) continue;
                variant_nbts.func_74778_a(Integer.toString(layer), this.inheritedLayers.get(layer));
            }
        }
        if (!this.inheritedTints.isEmpty()) {
            variant_nbts.func_218657_a("Tint", (INBT)new CompoundNBT());
            for (layer = 0; layer < 3; ++layer) {
                if (!this.inheritedTints.containsKey(layer)) continue;
                variant_nbts.func_74775_l("Tint").func_218657_a(Integer.toString(layer), (INBT)this.inheritedTints.get(layer));
            }
        }
        CompoundNBT compoundNBT = nbts = skullItem.func_77978_p() == null ? new CompoundNBT() : skullItem.func_77978_p();
        if (!this.inheritedLayers.isEmpty() || !this.inheritedTints.isEmpty()) {
            nbts.func_218657_a("Variant", (INBT)variant_nbts);
            skullItem.func_77982_d(nbts);
        }
        return skullItem;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationProgress(float partialTicks) {
        return ((AnotherAbstractSkullBlock)this.func_195044_w().func_177230_c()).getLivingEntityType() == CreeperEntity.class ? this.animTick + partialTicks : 0.0f;
    }

    private Double[] getActualPos() {
        Direction dir;
        double x = this.func_174877_v().func_177958_n();
        double y = this.func_174877_v().func_177956_o();
        double z = this.func_174877_v().func_177952_p();
        boolean onWall = this.func_195044_w().func_177230_c() instanceof AnotherWallSkullBlock;
        Direction direction = dir = onWall ? (Direction)this.func_195044_w().func_177229_b((IProperty)AnotherWallSkullBlock.FACING) : null;
        if (dir == null) {
            x += 0.5;
            y += 0.25;
            z += 0.5;
        } else {
            y += 0.5;
            switch (dir) {
                case NORTH: {
                    x += 0.5;
                    z += 0.74;
                    break;
                }
                case SOUTH: {
                    x += 0.5;
                    z += 0.26;
                    break;
                }
                case WEST: {
                    x += 0.74;
                    z += 0.5;
                    break;
                }
                case EAST: {
                    x += 0.26;
                    z += 0.5;
                    break;
                }
            }
        }
        return new Double[]{x, y, z};
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (world.field_72995_K) {
            Class<? extends LivingEntity> entityType = ((AnotherAbstractSkullBlock)this.func_195044_w().func_177230_c()).getLivingEntityType();
            if (CommonProxy.GLOBAL_SKULL_DATA.get(entityType).doesTick()) {
                this.animTick += 1.0f;
            }
            if (CommonProxy.GLOBAL_SKULL_DATA.get(entityType).getTickFn() != null) {
                CommonProxy.GLOBAL_SKULL_DATA.get(entityType).getTickFn().accept(this, this.getActualPos());
            }
        }
    }
}

