/*
 * Decompiled with CFR 0.152.
 */
package com.fuffles.justanotherheadmod.event;

import com.fuffles.justanotherheadmod.JustAnotherHeadMod;
import com.fuffles.justanotherheadmod.common.item.AnotherSkullItem;
import com.fuffles.justanotherheadmod.proxy.CommonProxy;
import com.fuffles.justanotherheadmod.registry.RegisterBeheading;
import com.fuffles.justanotherheadmod.registry.RegisterSkulls;
import com.fuffles.justanotherheadmod.util.AdvancementPusher;
import net.minecraft.advancements.Advancement;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class SkullDropEvent {
    private static double BASE_DROP_CHANCE = 0.025;
    private static double MULT_PER_LOOTING = 0.01;
    private static double MULT_SKULL_LOOTING = 0.15;

    public static void playerEvent(LivingDropsEvent dropEvent, ItemStack skullItem) {
        Entity srcEnt = dropEvent.getSource().func_76346_g();
        if (srcEnt instanceof PlayerEntity) {
            int beheading = EnchantmentHelper.func_185284_a((Enchantment)RegisterBeheading.BEHEADING, (LivingEntity)((LivingEntity)srcEnt));
            double dropChance = BASE_DROP_CHANCE + (double)dropEvent.getLootingLevel() * MULT_PER_LOOTING + (double)beheading * MULT_SKULL_LOOTING;
            if (Math.random() <= dropChance) {
                dropEvent.getEntityLiving().func_199701_a_(skullItem);
                if (beheading > 0 && srcEnt instanceof ServerPlayerEntity) {
                    AdvancementPusher.push((ServerPlayerEntity)srcEnt, "justanotherheadmod:adventure/behead_any_mob");
                }
            }
        }
    }

    public static void creeperEvent(LivingDropsEvent dropEvent, ItemStack skullItem) {
        CreeperEntity creeper;
        LivingEntity victim = dropEvent.getEntityLiving();
        Entity killer = dropEvent.getSource().func_76346_g();
        if (killer instanceof CreeperEntity && ((creeper = (CreeperEntity)killer).func_70650_aV() || victim instanceof ZombieEntity)) {
            creeper.func_175493_co();
            dropEvent.getEntityLiving().func_199701_a_(skullItem);
            if (creeper.getPersistentData().func_74764_b("justanotherheadmod:igniter")) {
                ServerPlayerEntity player = (ServerPlayerEntity)creeper.field_70170_p.func_73045_a(creeper.getPersistentData().func_74762_e("justanotherheadmod:igniter"));
                AdvancementPusher.push(player, "justanotherheadmod:adventure/nuke_any_mob");
                if (victim.getClass() == EnderDragonEntity.class) {
                    Advancement freeEnd = null;
                    for (Advancement adv : player.func_184102_h().func_191949_aK().func_195438_b()) {
                        if (!adv.func_192067_g().toString().equals("minecraft:end/kill_dragon")) continue;
                        freeEnd = adv;
                        break;
                    }
                    if (freeEnd != null) {
                        player.func_184102_h().func_184103_al().func_148539_a((ITextComponent)new TranslationTextComponent("chat.type.advancement.task", new Object[]{creeper.func_145748_c_(), freeEnd.func_193123_j()}));
                    }
                    AdvancementPusher.push(player, "justanotherheadmod:end/nuke_dragon");
                } else if (victim.getClass() == WitherEntity.class) {
                    AdvancementPusher.push(player, "justanotherheadmod:nether/nuke_wither");
                }
            }
        }
    }

    public static void onSkullDropEvent(LivingDropsEvent dropEvent) {
        LivingEntity victim = dropEvent.getEntityLiving();
        Entity killer = dropEvent.getSource().func_76346_g();
        if (CommonProxy.GLOBAL_SKULL_DATA.containsKey(victim.getClass()) && !victim.getClass().equals(CreeperEntity.class)) {
            ItemStack skullItem = new ItemStack((IItemProvider)RegisterSkulls.SKULL_ITEMS.get(victim.getClass()));
            if (CommonProxy.GLOBAL_SKULL_DATA.get(victim.getClass()).getSkullDropFn() != null) {
                skullItem = CommonProxy.GLOBAL_SKULL_DATA.get(victim.getClass()).getSkullDropFn().apply(dropEvent, skullItem);
            }
            SkullDropEvent.creeperEvent(dropEvent, skullItem);
            SkullDropEvent.playerEvent(dropEvent, skullItem);
        } else if (victim.getClass().equals(CreeperEntity.class)) {
            CompoundNBT nbts = dropEvent.getEntityLiving().func_189511_e(new CompoundNBT());
            ItemStack skullItem = new ItemStack((IItemProvider)Items.field_196185_dy);
            if (nbts.func_74764_b("powered") && nbts.func_74767_n("powered")) {
                skullItem = new ItemStack((IItemProvider)RegisterSkulls.SKULL_ITEMS.get(victim.getClass()));
                AnotherSkullItem.setVariant(skullItem, 1, "charged");
            }
            SkullDropEvent.playerEvent(dropEvent, skullItem);
            boolean dropFlag = false;
            ItemEntity dropSkull = null;
            for (ItemEntity item : dropEvent.getDrops()) {
                if (item.func_92059_d().func_77973_b() != Items.field_196185_dy) continue;
                JustAnotherHeadMod.LOG.info("Item found!");
                dropFlag = true;
                dropSkull = item;
                break;
            }
            if (dropEvent.getSource().func_76346_g() instanceof CreeperEntity && dropFlag) {
                ServerPlayerEntity player = (ServerPlayerEntity)dropEvent.getSource().func_76346_g().field_70170_p.func_73045_a(dropEvent.getSource().func_76346_g().getPersistentData().func_74762_e("justanotherheadmod:igniter"));
                AdvancementPusher.push(player, "justanotherheadmod:adventure/nuke_any_mob");
                if (nbts.func_74764_b("powered") && nbts.func_74767_n("powered")) {
                    AdvancementPusher.push(player, "justanotherheadmod:adventure/nuke_charged_creeper");
                    dropSkull.func_70106_y();
                    dropEvent.getEntityLiving().func_199701_a_(skullItem);
                }
            }
        } else if (victim.getClass().equals(EnderDragonEntity.class)) {
            ItemStack skullItem = new ItemStack((IItemProvider)Items.field_196151_dA);
            SkullDropEvent.creeperEvent(dropEvent, skullItem);
            SkullDropEvent.playerEvent(dropEvent, skullItem);
        } else if (victim instanceof PlayerEntity) {
            int beheading;
            ItemStack skullItem = new ItemStack((IItemProvider)Items.field_196184_dx);
            CompoundNBT skullNBTs = skullItem.func_77942_o() ? skullItem.func_77978_p() : new CompoundNBT();
            skullNBTs.func_74778_a("SkullOwner", ((PlayerEntity)victim).func_146103_bH().getName());
            skullItem.func_77982_d(skullNBTs);
            SkullDropEvent.creeperEvent(dropEvent, skullItem);
            if (killer instanceof PlayerEntity && (beheading = EnchantmentHelper.func_185284_a((Enchantment)RegisterBeheading.BEHEADING, (LivingEntity)((LivingEntity)killer))) > 0) {
                dropEvent.getEntityLiving().func_199701_a_(skullItem);
            }
        } else if (victim.getClass().equals(SkeletonEntity.class)) {
            SkullDropEvent.playerEvent(dropEvent, new ItemStack((IItemProvider)Items.field_196182_dv));
            boolean dropFlag = false;
            for (ItemEntity item : dropEvent.getDrops()) {
                if (item.func_92059_d().func_77973_b() != Items.field_196182_dv) continue;
                dropFlag = true;
            }
            if (killer instanceof CreeperEntity && dropFlag && killer.getPersistentData().func_74764_b("justanotherheadmod:igniter")) {
                ServerPlayerEntity player = (ServerPlayerEntity)killer.field_70170_p.func_73045_a(killer.getPersistentData().func_74762_e("justanotherheadmod:igniter"));
                AdvancementPusher.push(player, "justanotherheadmod:adventure/nuke_any_mob");
            }
        } else if (victim.getClass().equals(TraderLlamaEntity.class)) {
            ItemStack skullItem = CommonProxy.GLOBAL_SKULL_DATA.get(LlamaEntity.class).getSkullDropFn().apply(dropEvent, new ItemStack((IItemProvider)RegisterSkulls.SKULL_ITEMS.get(LlamaEntity.class)));
            SkullDropEvent.creeperEvent(dropEvent, skullItem);
            SkullDropEvent.playerEvent(dropEvent, skullItem);
        } else if (victim.getClass().equals(WitherSkeletonEntity.class)) {
            boolean dropFlag = false;
            for (ItemEntity item : dropEvent.getDrops()) {
                if (item.func_92059_d().func_77973_b() != Items.field_196183_dw) continue;
                dropFlag = true;
            }
            if (killer instanceof PlayerEntity && !dropFlag) {
                int beheading = EnchantmentHelper.func_185284_a((Enchantment)RegisterBeheading.BEHEADING, (LivingEntity)((LivingEntity)dropEvent.getSource().func_76346_g()));
                if (beheading > 0) {
                    double dropChance = BASE_DROP_CHANCE + (double)beheading * MULT_SKULL_LOOTING;
                    if (Math.random() <= dropChance) {
                        dropEvent.getEntityLiving().func_199703_a((IItemProvider)Items.field_196183_dw);
                    }
                }
            } else if (killer instanceof CreeperEntity && dropFlag && killer.getPersistentData().func_74764_b("justanotherheadmod:igniter")) {
                ServerPlayerEntity player = (ServerPlayerEntity)killer.field_70170_p.func_73045_a(killer.getPersistentData().func_74762_e("justanotherheadmod:igniter"));
                AdvancementPusher.push(player, "justanotherheadmod:adventure/nuke_any_mob");
            }
        } else if (victim.getClass().equals(ZombieEntity.class)) {
            SkullDropEvent.playerEvent(dropEvent, new ItemStack((IItemProvider)Items.field_196186_dz));
            boolean dropFlag = false;
            for (ItemEntity item : dropEvent.getDrops()) {
                if (item.func_92059_d().func_77973_b() != Items.field_196186_dz) continue;
                dropFlag = true;
            }
            if (killer instanceof CreeperEntity && dropFlag && killer.getPersistentData().func_74764_b("justanotherheadmod:igniter")) {
                ServerPlayerEntity player = (ServerPlayerEntity)killer.field_70170_p.func_73045_a(killer.getPersistentData().func_74762_e("justanotherheadmod:igniter"));
                AdvancementPusher.push(player, "justanotherheadmod:adventure/nuke_any_mob");
            }
        }
    }

    public static void onIgniteCreeper(PlayerInteractEvent.EntityInteract interactEvent) {
        Entity interactee = interactEvent.getTarget();
        if (interactee instanceof CreeperEntity && interactEvent.getItemStack().func_77973_b() == Items.field_151033_d) {
            interactee.getPersistentData().func_74768_a("justanotherheadmod:igniter", interactEvent.getPlayer().func_145782_y());
        }
    }
}

