/*
 * Decompiled with CFR 0.152.
 */
package com.fuffles.justanotherheadmod.registry;

import com.fuffles.justanotherheadmod.JustAnotherHeadMod;
import com.fuffles.justanotherheadmod.client.render.AnotherSkullItemStackTileEntityRenderer;
import com.fuffles.justanotherheadmod.common.block.AnotherSkullBlock;
import com.fuffles.justanotherheadmod.common.block.AnotherWallSkullBlock;
import com.fuffles.justanotherheadmod.common.item.AnotherSkullItem;
import com.fuffles.justanotherheadmod.proxy.CommonProxy;
import com.fuffles.justanotherheadmod.util.BiBlock;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegisterSkulls {
    public static Map<Class<? extends LivingEntity>, BiBlock> SKULL_BLOCKS = new HashMap<Class<? extends LivingEntity>, BiBlock>();
    public static Map<Class<? extends LivingEntity>, Item> SKULL_ITEMS = new HashMap<Class<? extends LivingEntity>, Item>();

    private static Block makeNewSkullBlock(String id, Class<? extends LivingEntity> type, @Nullable Block lootBlock) {
        if (lootBlock != null) {
            return (Block)new AnotherWallSkullBlock(type, Block.Properties.func_200950_a((Block)Blocks.field_196703_eM).func_222379_b(lootBlock)).setRegistryName("justanotherheadmod", id);
        }
        return (Block)new AnotherSkullBlock(type, Block.Properties.func_200950_a((Block)Blocks.field_196703_eM)).setRegistryName("justanotherheadmod", id);
    }

    private static Item makeNewSkullItem(AnotherSkullBlock floorSkull, AnotherWallSkullBlock wallSkull) {
        if (floorSkull.getLivingEntityType() == BlazeEntity.class) {
            return (Item)new AnotherSkullItem(floorSkull, wallSkull, new Item.Properties().func_200916_a(ItemGroup.field_78031_c).func_208103_a(Rarity.UNCOMMON).setISTER(() -> AnotherSkullItemStackTileEntityRenderer::new)).setRegistryName(floorSkull.getRegistryName());
        }
        return (Item)new AnotherSkullItem(floorSkull, wallSkull, new Item.Properties().func_208103_a(Rarity.UNCOMMON).setISTER(() -> AnotherSkullItemStackTileEntityRenderer::new)).setRegistryName(floorSkull.getRegistryName());
    }

    @SubscribeEvent
    public static void registerSkullBlocks(RegistryEvent.Register<Block> registerBlocks) {
        for (Class<? extends LivingEntity> ent : CommonProxy.GLOBAL_SKULL_DATA.keySet()) {
            JustAnotherHeadMod.LOG.info("Skull Block Entity: " + ent);
            AnotherSkullBlock block1 = (AnotherSkullBlock)RegisterSkulls.makeNewSkullBlock(CommonProxy.GLOBAL_SKULL_DATA.get(ent).getRegistryID(), ent, null);
            AnotherWallSkullBlock block2 = (AnotherWallSkullBlock)RegisterSkulls.makeNewSkullBlock(CommonProxy.GLOBAL_SKULL_DATA.get(ent).getRegistryID() + "_wall", ent, (Block)block1);
            SKULL_BLOCKS.put(ent, new BiBlock((Block)block1, (Block)block2));
            CommonProxy.SKULLS.add(SKULL_BLOCKS.get(ent).getBlock1());
            CommonProxy.SKULLS.add(SKULL_BLOCKS.get(ent).getBlock2());
            registerBlocks.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{SKULL_BLOCKS.get(ent).getBlock1(), SKULL_BLOCKS.get(ent).getBlock2()});
        }
    }

    @SubscribeEvent
    public static void registerSkullItems(RegistryEvent.Register<Item> registerItems) {
        if (!SKULL_BLOCKS.isEmpty()) {
            for (Class<? extends LivingEntity> ent : SKULL_BLOCKS.keySet()) {
                JustAnotherHeadMod.LOG.info("Skull Item Entity: " + ent);
                SKULL_ITEMS.put(ent, RegisterSkulls.makeNewSkullItem((AnotherSkullBlock)SKULL_BLOCKS.get(ent).getBlock1(), (AnotherWallSkullBlock)SKULL_BLOCKS.get(ent).getBlock2()));
                registerItems.getRegistry().register((IForgeRegistryEntry)SKULL_ITEMS.get(ent));
            }
        }
    }
}

