/*
 * Decompiled with CFR 0.152.
 */
package com.fuffles.justanotherheadmod.registry;

import com.fuffles.justanotherheadmod.JustAnotherHeadMod;
import com.fuffles.justanotherheadmod.common.block.PillarBlock;
import com.fuffles.justanotherheadmod.util.IPillarConstructor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegisterVanillaPillars {
    public static Map<VanillaPillar, Block> VANILLA_PILLARS = new HashMap<VanillaPillar, Block>();
    public static Map<Block, BlockItem> VANILLA_PILLAR_ITEMS = new HashMap<Block, BlockItem>();

    private static PillarBlock makeNewPillar(String id, Block.Properties properties) {
        return (PillarBlock)new PillarBlock(properties).setRegistryName("justanotherheadmod", id);
    }

    private static BlockItem makeNewPillarItem(PillarBlock block) {
        return (BlockItem)new BlockItem((Block)block, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(block.getRegistryName());
    }

    @SubscribeEvent
    public static void registerPillarBlocks(RegistryEvent.Register<Block> registerBlocks) {
        for (VanillaPillar pillar : VanillaPillar.values()) {
            JustAnotherHeadMod.LOG.info("Pillar Val: " + pillar);
            VANILLA_PILLARS.put(pillar, RegisterVanillaPillars.makeNewPillar(pillar.getID() + "_pillar", pillar.getProps()));
            registerBlocks.getRegistry().register((IForgeRegistryEntry)VANILLA_PILLARS.get(pillar));
        }
    }

    @SubscribeEvent
    public static void registerPillarItems(RegistryEvent.Register<Item> registerItems) {
        if (!VANILLA_PILLARS.isEmpty()) {
            for (VanillaPillar pillar : VanillaPillar.values()) {
                if (!VANILLA_PILLARS.containsKey(pillar)) continue;
                JustAnotherHeadMod.LOG.info("Pillar Val: " + pillar);
                VANILLA_PILLAR_ITEMS.put(VANILLA_PILLARS.get(pillar), RegisterVanillaPillars.makeNewPillarItem((PillarBlock)VANILLA_PILLARS.get(pillar)));
                registerItems.getRegistry().register((IForgeRegistryEntry)VANILLA_PILLAR_ITEMS.get(VANILLA_PILLARS.get(pillar)));
            }
        }
    }

    public static enum VanillaPillar implements IPillarConstructor
    {
        STONE_BRICK("stone_brick", Block.Properties.func_200950_a((Block)Blocks.field_196696_di)),
        SANDSTONE("sandstone", Block.Properties.func_200950_a((Block)Blocks.field_150322_A)),
        QUARTZ("quartz", Block.Properties.func_200950_a((Block)Blocks.field_150371_ca)),
        PRISMARINE("prismarine", Block.Properties.func_200950_a((Block)Blocks.field_180397_cI)),
        NETHER_BRICK("nether_brick", Block.Properties.func_200950_a((Block)Blocks.field_196653_dH).func_200951_a(3)),
        PURPUR("purpur", Block.Properties.func_200950_a((Block)Blocks.field_185767_cT).func_200948_a(1.5f, 1200.0f));

        private String id;
        private Block.Properties props;

        private VanillaPillar(String id, Block.Properties properties) {
            this.id = id;
            this.props = properties;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public Block.Properties getProps() {
            return this.props;
        }
    }
}

