/*
 * Decompiled with CFR 0.152.
 */
package com.fuffles.justanotherheadmod.util;

import com.fuffles.justanotherheadmod.util.SkullModifier;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class SkullData {
    private String reg_id;
    private Object list_index;
    private double nudge;
    private boolean ticks;
    private Map<SkullResourceType, Object> resourceMap;
    private BiFunction<LivingDropsEvent, ItemStack, ItemStack> dropFn;
    private SkullModifier[] creativeVariants;
    private BiConsumer<TileEntity, Double[]> tickFn;

    public SkullData(String registry_id, Object list_index, Map<SkullResourceType, Object> resources) {
        this.reg_id = registry_id;
        this.list_index = list_index;
        this.nudge = 0.0;
        this.ticks = false;
        this.resourceMap = resources;
        this.dropFn = null;
        this.creativeVariants = null;
        this.tickFn = null;
    }

    public SkullData(String registry_id, Object list_index, double wall_nudge, Map<SkullResourceType, Object> resources, BiFunction<LivingDropsEvent, ItemStack, ItemStack> drop_function) {
        this.reg_id = registry_id;
        this.list_index = list_index;
        this.nudge = wall_nudge;
        this.ticks = false;
        this.resourceMap = resources;
        this.dropFn = drop_function;
        this.creativeVariants = null;
        this.tickFn = null;
    }

    public SkullData(String registry_id, Object list_index, double wall_nudge, Map<SkullResourceType, Object> resources, BiFunction<LivingDropsEvent, ItemStack, ItemStack> drop_function, SkullModifier[] creative_item_stacks) {
        this.reg_id = registry_id;
        this.list_index = list_index;
        this.nudge = wall_nudge;
        this.ticks = false;
        this.resourceMap = resources;
        this.dropFn = drop_function;
        this.creativeVariants = creative_item_stacks;
        this.tickFn = null;
    }

    public SkullData(String registry_id, Object list_index, double wall_nudge, boolean does_tick, Map<SkullResourceType, Object> resources, BiFunction<LivingDropsEvent, ItemStack, ItemStack> drop_function, SkullModifier[] creative_item_stacks, BiConsumer<TileEntity, Double[]> ticking_function) {
        this.reg_id = registry_id;
        this.list_index = list_index;
        this.nudge = wall_nudge;
        this.ticks = does_tick;
        this.resourceMap = resources;
        this.dropFn = drop_function;
        this.creativeVariants = creative_item_stacks;
        this.tickFn = ticking_function;
    }

    public String getRegistryID() {
        return this.reg_id;
    }

    public Object getCreativeListIndex() {
        return this.list_index;
    }

    public double getWallNudge() {
        return this.nudge;
    }

    public boolean doesTick() {
        return this.ticks;
    }

    public Object getResource(SkullResourceType type) {
        return this.resourceMap.get((Object)type) != null ? this.resourceMap.get((Object)type) : null;
    }

    public BiFunction<LivingDropsEvent, ItemStack, ItemStack> getSkullDropFn() {
        return this.dropFn;
    }

    public SkullModifier[] getCreativeItemVariants() {
        return this.creativeVariants;
    }

    public BiConsumer<TileEntity, Double[]> getTickFn() {
        return this.tickFn;
    }

    public static enum SkullResourceType {
        L0,
        R0,
        L1,
        R1,
        L2,
        R2;

    }
}

