/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import snownee.kiwi.ModuleInfo;
import snownee.kiwi.block.ModBlock;

public abstract class AbstractModule {
    protected ResourceLocation uid;
    private static final BiConsumer<ModuleInfo, Item> ITEM_DECORATOR = (module, item) -> {
        if (module.group != null && item.field_77701_a == null && !module.noGroups.contains(item)) {
            item.field_77701_a = module.group;
        }
    };
    private static final Map<Class<?>, BiConsumer<ModuleInfo, ? extends IForgeRegistryEntry<?>>> DEFAULT_DECORATORS = ImmutableMap.of(Item.class, ITEM_DECORATOR);
    protected final Map<Class<?>, BiConsumer<ModuleInfo, ? extends IForgeRegistryEntry<?>>> decorators = Maps.newHashMap(DEFAULT_DECORATORS);

    protected void preInit() {
    }

    protected void init(FMLCommonSetupEvent event) {
    }

    protected void clientInit(FMLClientSetupEvent event) {
    }

    protected void serverInit(FMLServerStartingEvent event) {
    }

    protected void postInit() {
    }

    protected static Item.Properties itemProp() {
        return new Item.Properties();
    }

    protected static AbstractBlock.Properties blockProp(Material material) {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)material);
        properties.func_200947_a(ModBlock.deduceSoundType(material));
        properties.func_200943_b(ModBlock.deduceHardness(material));
        return properties;
    }

    protected static AbstractBlock.Properties blockProp(AbstractBlock block) {
        return AbstractBlock.Properties.func_200950_a((AbstractBlock)block);
    }

    public static ITag.INamedTag<Item> itemTag(String namespace, String path) {
        return ItemTags.func_199901_a((String)(namespace + ":" + path));
    }

    public static ITag.INamedTag<EntityType<?>> entityTag(String namespace, String path) {
        return EntityTypeTags.func_232896_a_((String)(namespace + ":" + path));
    }

    public static ITag.INamedTag<Block> blockTag(String namespace, String path) {
        return BlockTags.func_199894_a((String)(namespace + ":" + path));
    }

    public static ITag.INamedTag<Fluid> fluidTag(String namespace, String path) {
        return FluidTags.func_206956_a((String)(namespace + ":" + path));
    }

    public ResourceLocation RL(String path) {
        return new ResourceLocation(this.uid.func_110624_b(), path);
    }
}

