/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.CrashReportExtender;
import net.minecraftforge.fml.ModLoadingContext;
import org.apache.commons.lang3.StringUtils;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.ModContext;
import snownee.kiwi.ModuleInfo;

public final class KiwiManager {
    public static final Map<ResourceLocation, ModuleInfo> MODULES = Maps.newLinkedHashMap();

    private KiwiManager() {
    }

    public static void addInstance(ResourceLocation resourceLocation, AbstractModule module, ModContext context) {
        if (MODULES.containsKey(resourceLocation)) {
            Kiwi.logger.error(Kiwi.MARKER, "Found a duplicate module name {}, skipping.", (Object)resourceLocation);
        } else {
            MODULES.put(resourceLocation, new ModuleInfo(resourceLocation, module, context));
        }
    }

    static void handleRegister(RegistryEvent.Register<?> event) {
        MODULES.values().forEach(info -> info.handleRegister(event));
        ModLoadingContext.get().setActiveContainer(null, null);
    }

    static {
        CrashReportExtender.registerCrashCallable((String)"Kiwi Modules", () -> "\n" + MODULES.keySet().stream().map(ResourceLocation::toString).sorted(StringUtils::compare).collect(Collectors.joining("\n\t\t", "\t\t", "")));
    }
}

