/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.abilities;

import java.awt.Color;
import java.util.List;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityToggle;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataBoolean;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataColor;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataFloat;
import lucraft.mods.lucraftcore.superpowers.render.RenderSuperpowerLayerEvent;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import lucraft.mods.lucraftcore.util.helper.PlayerHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import spyeedy.mods.lcu.util.LCUIconHelper;

public class AbilityAura
extends AbilityToggle {
    public static final AbilityData<Color> COLOR = new AbilityDataColor("color").disableSaving().enableSetting("color", "Color of the aura.");
    public static final AbilityData<Float> ALPHA = new AbilityDataFloat("alpha").disableSaving().enableSetting("alpha", "Transparency of the aura. Values between 0 - 1");
    public static final AbilityData<Boolean> GLOW = new AbilityDataBoolean("glow").disableSaving().enableSetting("glow", "Make the aura glow.");

    public AbilityAura(EntityLivingBase entity) {
        super(entity);
    }

    public void registerData() {
        super.registerData();
        this.dataManager.register(COLOR, (Object)Color.GREEN);
        this.dataManager.register(ALPHA, (Object)Float.valueOf(0.25f));
        this.dataManager.register(GLOW, (Object)false);
    }

    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        Color color = (Color)this.getDataManager().get(COLOR);
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)(color.getRed() / 255), (float)(color.getGreen() / 255), (float)(color.getBlue() / 255));
        LCUIconHelper.drawAbilityIcon(mc, gui, x, y, 1, 1);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        LCUIconHelper.drawAbilityIcon(mc, gui, x, y, 1, 0);
        GlStateManager.func_179121_F();
    }

    public void updateTick() {
    }

    @Mod.EventBusSubscriber(modid="spylcu", value={Side.CLIENT})
    public static class Renderer {
        private static ResourceLocation[] auraTexture = new ResourceLocation[]{new ResourceLocation("spylcu:textures/entity/aura_steve.png"), new ResourceLocation("spylcu:textures/entity/aura_alex.png")};

        @SubscribeEvent
        public static void onRenderLayer(RenderSuperpowerLayerEvent e) {
            if (Minecraft.func_71410_x().field_71439_g == null) {
                return;
            }
            EntityPlayer player = e.getPlayer();
            for (AbilityAura abilityAura : Ability.getAbilitiesFromClass((List)Ability.getAbilities((EntityLivingBase)player), AbilityAura.class)) {
                if (abilityAura == null || !abilityAura.isEnabled()) continue;
                Color color = (Color)abilityAura.getDataManager().get(COLOR);
                float alpha = ((Float)abilityAura.getDataManager().get(ALPHA)).floatValue();
                float playerScale = 1.0f;
                ModelPlayer playerModel = new ModelPlayer(playerScale, PlayerHelper.hasSmallArms((EntityPlayer)player));
                if (PlayerHelper.hasSmallArms((EntityPlayer)player)) {
                    e.getRenderPlayer().func_110776_a(auraTexture[PlayerHelper.hasSmallArms((EntityPlayer)player) ? 1 : 0]);
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                if (((Boolean)abilityAura.getDataManager().get(GLOW)).booleanValue()) {
                    LCRenderHelper.setLightmapTextureCoords((float)240.0f, (float)240.0f);
                    GlStateManager.func_179140_f();
                }
                GlStateManager.func_179131_c((float)(color.getRed() / 255), (float)(color.getGreen() / 255), (float)(color.getBlue() / 255), (float)alpha);
                playerModel.func_178686_a((ModelBase)e.getRenderPlayer().func_177087_b());
                playerModel.func_78088_a((Entity)player, e.getLimbSwing(), e.getLimbSwingAmount(), e.getAgeInTicks(), e.getNetHeadYaw(), e.getHeadPitch(), e.getScale());
                if (((Boolean)abilityAura.getDataManager().get(GLOW)).booleanValue()) {
                    LCRenderHelper.restoreLightmapTextureCoords();
                    GlStateManager.func_179145_e();
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
        }
    }
}

