/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.abilities;

import java.awt.Color;
import java.util.Map;
import lucraft.mods.lucraftcore.LCConfig;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityToggle;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataColor;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataInteger;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityCondition;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityConditionAbility;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.AbilityContainer;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.superpowers.events.AbilityKeyEvent;
import lucraft.mods.lucraftcore.util.abilitybar.AbilityBarPos;
import lucraft.mods.lucraftcore.util.helper.LCRenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import spyeedy.mods.lcu.abilities.AbilityRechargeLantern;
import spyeedy.mods.lcu.abilities.condition.AbilityConditionAbilityLCU;
import spyeedy.mods.lcu.abilities.condition.AbilityConditionLanternEnergy;
import spyeedy.mods.lcu.util.LCUIconHelper;

public class AbilityLantern
extends AbilityToggle {
    public static final AbilityData<Integer> LANTERN_ENERGY = new AbilityDataInteger("lantern_energy").setSyncType(EnumSync.SELF);
    public static final AbilityData<Integer> MAX_LANTERN_ENERGY = new AbilityDataInteger("max_lantern_energy").disableSaving().setSyncType(EnumSync.SELF).enableSetting("max_lantern_energy", "The maximum amount of lantern energy you can have");
    public static final AbilityData<Color> COLOR = new AbilityDataColor("color").disableSaving().enableSetting("color", "Sets for HUD colors");

    public AbilityLantern(EntityLivingBase entity) {
        super(entity);
    }

    public void init(Map<String, Ability> abilities) {
        super.init(abilities);
    }

    public void registerData() {
        super.registerData();
        this.dataManager.register(LANTERN_ENERGY, (Object)0);
        this.dataManager.register(MAX_LANTERN_ENERGY, (Object)100);
        this.dataManager.register(COLOR, (Object)Color.GREEN);
    }

    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        LCUIconHelper.drawAbilityIcon(mc, gui, x, y, 0, 0);
    }

    public void updateTick() {
        AbilityContainer container = Ability.getAbilityContainer((Ability.EnumAbilityContext)this.context, (EntityLivingBase)this.entity);
        if (container == null) {
            return;
        }
        if (this.isEnabled()) {
            for (Ability ab : container.getAbilities()) {
                if (ab instanceof AbilityRechargeLantern) continue;
                for (AbilityCondition condition : ab.getConditions()) {
                    AbilityConditionLanternEnergy conditionLanternEnergy;
                    if (!(condition instanceof AbilityConditionLanternEnergy) || !(conditionLanternEnergy = (AbilityConditionLanternEnergy)condition).getAbilityKey().equals(this.getKey())) continue;
                    if (conditionLanternEnergy.getRequiredEnergy() > this.getLanternEnergy()) {
                        if (ab.getAbilityType() != Ability.AbilityType.TOGGLE) continue;
                        ab.setEnabled(false);
                        continue;
                    }
                    if (!ab.isUnlocked() || !ab.isEnabled() || this.entity.field_70173_aa % (conditionLanternEnergy.getFrequency() * 20) != 0) continue;
                    this.setLanternEnergy(this.getLanternEnergy() - conditionLanternEnergy.getRequiredEnergy());
                }
            }
        }
    }

    public void setEnabled(boolean enabled) {
        AbilityContainer container;
        if (!enabled && (container = Ability.getAbilityContainer((Ability.EnumAbilityContext)this.context, (EntityLivingBase)this.entity)) != null) {
            for (Ability ab : container.getAbilities()) {
                if (ab.getKey().equals(this.getKey())) continue;
                for (AbilityCondition condition : ab.getConditions()) {
                    if (!(condition instanceof AbilityConditionAbility) && !(condition instanceof AbilityConditionAbilityLCU) || !condition.test((Ability)this) || !ab.isEnabled()) continue;
                    ab.action();
                }
            }
        }
        super.setEnabled(enabled);
    }

    public void setLanternEnergy(int lanternEnergy) {
        lanternEnergy = MathHelper.func_76125_a((int)lanternEnergy, (int)0, (int)this.getMaxLanternEnergy());
        this.dataManager.set(LANTERN_ENERGY, (Object)lanternEnergy);
    }

    public int getLanternEnergy() {
        return (Integer)this.dataManager.get(LANTERN_ENERGY);
    }

    public int getMaxLanternEnergy() {
        return (Integer)this.dataManager.get(MAX_LANTERN_ENERGY);
    }

    public Color getColor() {
        return (Color)this.dataManager.get(COLOR);
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT}, modid="spylcu")
    public static class Renderer {
        public static final ResourceLocation HUD_TEX = new ResourceLocation("spylcu", "textures/gui/hud.png");
        private static Minecraft mc = Minecraft.func_71410_x();

        @SubscribeEvent
        public static void postRenderGameOverlay(RenderGameOverlayEvent.Post e) {
            if (e.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE || Renderer.mc.field_71474_y.field_74330_P) {
                return;
            }
            ScaledResolution res = e.getResolution();
            AbilityBarPos barPos = LCConfig.abilityBar;
            for (Ability ability : Ability.getAbilities((EntityLivingBase)Renderer.mc.field_71439_g)) {
                if (!(ability instanceof AbilityLantern)) continue;
                GlStateManager.func_179094_E();
                int barWidth = 8;
                int barHeight = 107;
                int energyBarWidth = 2;
                int energyBarHeight = 99;
                int posX = 0;
                int posY = 0;
                AbilityLantern ab = (AbilityLantern)ability;
                Color color = ab.getColor();
                int energy = ab.getLanternEnergy();
                int strWidth = Renderer.mc.field_71466_p.func_78256_a(energy + "%");
                int energyBarLength = Math.round((float)energy / (float)ab.getMaxLanternEnergy() * (float)(energyBarHeight + 1));
                posX = barPos == AbilityBarPos.LEFT ? res.func_78326_a() - barWidth - 1 : ++posX;
                int strPosX = barPos == AbilityBarPos.LEFT ? res.func_78326_a() - strWidth - 1 : posX + 1;
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                LCRenderHelper.drawStringWithOutline((String)(energy + "%"), (int)strPosX, (int)(posY += 2), (int)color.getRGB(), (int)0);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                posY += 9;
                Renderer.mc.field_71446_o.func_110577_a(HUD_TEX);
                if (barPos == AbilityBarPos.LEFT) {
                    Gui.func_146110_a((int)posX, (int)posY, (float)0.0f, (float)0.0f, (int)barWidth, (int)barHeight, (float)128.0f, (float)128.0f);
                    if (energyBarLength > energyBarHeight) {
                        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                        Gui.func_73734_a((int)(posX + 4), (int)(posY + 3 + energyBarHeight), (int)(posX + 5), (int)(posY + 3 + energyBarHeight + 1), (int)color.getRGB());
                        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    }
                } else {
                    Gui.func_146110_a((int)posX, (int)posY, (float)9.0f, (float)0.0f, (int)barWidth, (int)barHeight, (float)128.0f, (float)128.0f);
                    if (energyBarLength > energyBarHeight) {
                        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                        Gui.func_73734_a((int)(posX + 3), (int)(posY + 3 + energyBarHeight), (int)(posX + 4), (int)(posY + 3 + energyBarHeight + 1), (int)color.getRGB());
                        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    }
                }
                GlStateManager.func_179124_c((float)(color.getRed() / 255), (float)(color.getGreen() / 255), (float)(color.getBlue() / 255));
                int actLength = energyBarLength > energyBarHeight ? energyBarHeight : energyBarLength;
                Gui.func_146110_a((int)(posX + 3), (int)(posY + 3), (float)18.0f, (float)0.0f, (int)energyBarWidth, (int)actLength, (float)128.0f, (float)128.0f);
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            }
        }
    }

    @Mod.EventBusSubscriber(modid="spylcu")
    public static class EventHandler {
        @SubscribeEvent
        public static void abilityKey(AbilityKeyEvent e) {
            Ability ab = e.ability;
            if (!(ab instanceof AbilityRechargeLantern) && ab.getAbilityType() == Ability.AbilityType.ACTION) {
                for (AbilityCondition condition : ab.getConditions()) {
                    if (!(condition instanceof AbilityConditionLanternEnergy)) continue;
                    AbilityConditionLanternEnergy conditionLanternEnergy = (AbilityConditionLanternEnergy)condition;
                    AbilityContainer container = Ability.getAbilityContainer((Ability.EnumAbilityContext)ab.context, (EntityLivingBase)ab.getEntity());
                    if (container == null) {
                        return;
                    }
                    for (Ability ab2 : container.getAbilities()) {
                        if (!(ab2 instanceof AbilityLantern) || !conditionLanternEnergy.getAbilityKey().equals(ab2.getKey())) continue;
                        AbilityLantern abilityLantern = (AbilityLantern)ab2;
                        if (conditionLanternEnergy.getRequiredEnergy() > abilityLantern.getLanternEnergy() || !e.pressed) continue;
                        abilityLantern.setLanternEnergy(abilityLantern.getLanternEnergy() - conditionLanternEnergy.getRequiredEnergy());
                    }
                }
            }
        }
    }
}

