/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.abilities;

import java.awt.Color;
import java.util.ArrayList;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityAction;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataColor;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataInteger;
import lucraft.mods.lucraftcore.superpowers.abilities.supplier.EnumSync;
import lucraft.mods.lucraftcore.superpowers.events.AbilityKeyEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import spyeedy.mods.lcu.abilities.data.AbilityDataEntityIdList;
import spyeedy.mods.lcu.entity.EntityProjectile;
import spyeedy.mods.lcu.gui.GuiProjectiles;
import spyeedy.mods.lcu.util.LCUIconHelper;

public class AbilityProjectiles
extends AbilityAction {
    public static final AbilityData<Color> COLOR = new AbilityDataColor("color").disableSaving().enableSetting("color", "Color of the projectiles.");
    public static final AbilityData<ArrayList<String>> ENTITY_IDS = new AbilityDataEntityIdList("entity_ids").disableSaving().enableSetting("entity_ids", "Sets the projectiles available to access.");
    private static final AbilityData<Integer> SELECTED_PROJECTILE = new AbilityDataInteger("selected_projectile").setSyncType(EnumSync.SELF);

    public AbilityProjectiles(EntityLivingBase entity) {
        super(entity);
    }

    public void registerData() {
        super.registerData();
        this.dataManager.register(COLOR, (Object)Color.GREEN);
        ArrayList<String> entityIds = new ArrayList<String>();
        entityIds.add("spylcu:dinosaur");
        entityIds.add("spylcu:plane");
        this.dataManager.register(ENTITY_IDS, entityIds);
        this.dataManager.register(SELECTED_PROJECTILE, (Object)0);
    }

    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        Color color = (Color)this.getDataManager().get(COLOR);
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)(color.getRed() / 255), (float)(color.getGreen() / 255), (float)(color.getBlue() / 255));
        LCUIconHelper.drawAbilityIcon(mc, gui, x, y, 1, 3);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        LCUIconHelper.drawAbilityIcon(mc, gui, x, y, 1, 2);
        GlStateManager.func_179121_F();
    }

    public void setSelectedProjectile(int selectedProjectile) {
        System.out.println("Setting (" + this.entity.field_70170_p.field_72995_K + "):" + selectedProjectile);
        this.dataManager.set(SELECTED_PROJECTILE, (Object)selectedProjectile);
    }

    public int getSelectedProjectile() {
        return (Integer)this.dataManager.get(SELECTED_PROJECTILE);
    }

    public ArrayList<String> getEntityIds() {
        return (ArrayList)this.dataManager.get(ENTITY_IDS);
    }

    public boolean action() {
        if (!this.getEntity().func_70093_af() && !this.entity.field_70170_p.field_72995_K) {
            EntityProjectile entity = new EntityProjectile(this.entity.field_70170_p, this.entity, this.getEntityIds().get(this.getSelectedProjectile()), (Color)this.getDataManager().get(COLOR));
            if (!entity.getJsonInfo().isDebugMode()) {
                entity.func_184538_a((Entity)this.entity, this.entity.field_70125_A, this.entity.field_70177_z, 0.0f, entity.getJsonInfo().getSpeed(), 0.0f);
            }
            this.entity.field_70170_p.func_72838_d((Entity)entity);
            return true;
        }
        return false;
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void lucraftKeyEvent(AbilityKeyEvent.Client e) {
            if (e.ability instanceof AbilityProjectiles && Minecraft.func_71410_x().field_71439_g.func_70093_af()) {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiProjectiles((AbilityProjectiles)e.ability));
            }
        }
    }
}

