/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.abilities;

import java.util.ArrayList;
import lucraft.mods.lucraftcore.superpowers.abilities.Ability;
import lucraft.mods.lucraftcore.superpowers.abilities.AbilityToggle;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityDataString;
import lucraft.mods.lucraftcore.superpowers.abilities.predicates.AbilityCondition;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import spyeedy.mods.lcu.LCUMod;
import spyeedy.mods.lcu.abilities.AbilityLantern;
import spyeedy.mods.lcu.abilities.condition.AbilityConditionAbilityLCU;
import spyeedy.mods.lcu.abilities.data.AbilityDataStringList;
import spyeedy.mods.lcu.block.LCUBlocks;
import spyeedy.mods.lcu.util.LCUIconHelper;

public class AbilityRechargeLantern
extends AbilityToggle {
    public static final AbilityData<String> BLOCK_TO_RECHARGE = new AbilityDataString("block_to_recharge").disableSaving().enableSetting("block_registry_name", "The block to interact with to recharge lantern energy.");
    public static final AbilityData<ArrayList<String>> OATH = new AbilityDataStringList("oath").disableSaving().enableSetting("oath", "Sets the oath to say when you recharge.");

    public AbilityRechargeLantern(EntityLivingBase entity) {
        super(entity);
    }

    public void registerData() {
        super.registerData();
        this.dataManager.register(BLOCK_TO_RECHARGE, (Object)LCUBlocks.GREEN_LANTERN_POWER_BATTERY.getRegistryName().toString());
        ArrayList<String> oaths = new ArrayList<String>();
        oaths.add("In Brightest Day, In Blackest Night");
        oaths.add("No evil shall escape my sight");
        oaths.add("Let those who worship evil's might");
        oaths.add("Beware my power");
        oaths.add("Green Lantern's Light!");
        this.dataManager.register(OATH, oaths);
    }

    public void drawIcon(Minecraft mc, Gui gui, int x, int y) {
        LCUIconHelper.drawAbilityIcon(mc, gui, x, y, 1, 4);
    }

    public boolean action() {
        if (!this.isEnabled()) {
            for (AbilityCondition condition : this.getConditions()) {
                if (!(condition instanceof AbilityConditionAbilityLCU) || !(((AbilityConditionAbilityLCU)condition).getAbility() instanceof AbilityLantern)) continue;
                return super.action();
            }
        } else {
            return super.action();
        }
        return false;
    }

    public void updateTick() {
    }

    public ArrayList<String> getOaths() {
        return (ArrayList)this.getDataManager().get(OATH);
    }

    @Mod.EventBusSubscriber(modid="spylcu")
    public static class EventHandler {
        @SubscribeEvent
        public static void blockInteract(PlayerInteractEvent.RightClickBlock event) {
            EntityPlayer player = event.getEntityPlayer();
            if (!(event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof BlockAir)) {
                Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
                for (Ability ability : Ability.getAbilities((EntityLivingBase)player)) {
                    if (!(ability instanceof AbilityRechargeLantern) || !ability.isEnabled() || !ability.isUnlocked()) continue;
                    String blockRegName = (String)ability.getDataManager().get(BLOCK_TO_RECHARGE);
                    for (AbilityCondition condition : ability.getConditions()) {
                        if (!(condition instanceof AbilityConditionAbilityLCU) || !(((AbilityConditionAbilityLCU)condition).getAbility() instanceof AbilityLantern)) continue;
                        AbilityLantern abilityLantern = (AbilityLantern)((AbilityConditionAbilityLCU)condition).getAbility();
                        if (!block.getRegistryName().toString().equals(blockRegName)) continue;
                        event.setCanceled(true);
                        if (!player.field_70170_p.field_72995_K) {
                            player.openGui((Object)LCUMod.instance, 0, player.field_70170_p, player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
                        }
                        abilityLantern.setLanternEnergy(abilityLantern.getMaxLanternEnergy());
                        ability.action();
                    }
                }
            }
        }
    }
}

