/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.abilities.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import lucraft.mods.lucraftcore.superpowers.abilities.data.AbilityData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.JsonUtils;

public class AbilityDataStringList
extends AbilityData<ArrayList<String>> {
    public AbilityDataStringList(String key) {
        super(key);
    }

    public ArrayList<String> parseValue(JsonObject jsonObject, ArrayList<String> defaultValue) {
        if (jsonObject.has(this.jsonKey)) {
            JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)jsonObject, (String)this.jsonKey);
            ArrayList<String> stringList = new ArrayList<String>();
            for (int idx = 0; idx < jsonArray.size(); ++idx) {
                String stringName = jsonArray.get(idx).getAsString();
                stringList.add(stringName);
            }
            return stringList;
        }
        return defaultValue;
    }

    public void writeToNBT(NBTTagCompound nbt, ArrayList<String> value) {
        NBTTagList stringsTagList = new NBTTagList();
        value.forEach(entityId -> stringsTagList.func_74742_a((NBTBase)new NBTTagString(entityId)));
        nbt.func_74782_a(this.key, (NBTBase)stringsTagList);
    }

    public ArrayList<String> readFromNBT(NBTTagCompound nbt, ArrayList<String> defaultValue) {
        if (nbt.func_74764_b(this.key)) {
            NBTTagList stringsTagList = nbt.func_150295_c(this.key, 8);
            ArrayList<String> stringList = new ArrayList<String>();
            for (int idx = 0; idx < stringsTagList.func_74745_c(); ++idx) {
                String stringName = stringsTagList.func_150307_f(idx);
                stringList.add(stringName);
            }
            return stringList;
        }
        return defaultValue;
    }

    public String getDisplay(ArrayList<String> value) {
        String jsonString = "";
        for (int idx = 0; idx < value.size(); ++idx) {
            jsonString = idx == 0 ? "\"" + value.get(idx) + "\"" : jsonString + ", \"" + value.get(idx) + "\"";
        }
        return "[ " + jsonString + " ]";
    }
}

