/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.addonpacks.entity;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import lucraft.mods.lucraftcore.addonpacks.AddonPackReadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FilenameUtils;
import spyeedy.mods.lcu.LCUMod;
import spyeedy.mods.lcu.addonpacks.entity.JsonProjectileInfo;

@Mod.EventBusSubscriber
public class AddonPackEntityReader {
    public static final LinkedHashMap<String, JsonProjectileInfo> PROJECTILES = new LinkedHashMap();

    @SubscribeEvent
    public static void onRead(AddonPackReadEvent e) {
        if (e.getDirectory().equals("constructs") && e.getResourceLocation().func_110623_a().contains("projectile\\") && FilenameUtils.getExtension((String)e.getFileName()).equalsIgnoreCase("json")) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(e.getInputStream(), StandardCharsets.UTF_8));
                JsonObject jsonobject = new JsonParser().parse((Reader)reader).getAsJsonObject();
                JsonProjectileInfo info = new JsonProjectileInfo();
                info.deserialize(jsonobject);
                String id = e.getResourceLocation().func_110624_b() + ":" + info.getEntityName();
                if (!PROJECTILES.containsKey(id)) {
                    PROJECTILES.put(id, info);
                    LCUMod.LOGGER.info("Successfully loaded LCU projectile '" + id + "'");
                } else {
                    System.out.println("There's already another projectile registered with the name '" + id + "'! Change your projectile's name!");
                }
            }
            catch (Exception e2) {
                LCUMod.LOGGER.error("Wasn't able to read projectile '" + e.getFileName() + "' in addon pack '" + e.getPackFile().getName() + "': " + e2.getMessage());
            }
        }
    }
}

