/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.addonpacks.entity;

import com.google.gson.JsonObject;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.JsonUtils;
import spyeedy.mods.lcu.addonpacks.entity.JsonEntityInfo;

public class JsonProjectileInfo
extends JsonEntityInfo {
    private float speed;
    private float damage;
    private EffectTypes effectType;
    private Effect effect;
    private boolean debugMode;

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public void setEffectType(EffectTypes type) {
        this.effectType = type;
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getDamage() {
        return this.damage;
    }

    public Effect getEffect() {
        return this.effect;
    }

    public EffectTypes getEffectType() {
        return this.effectType;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public JsonProjectileInfo deserialize(JsonObject object) {
        super.deserialize(object);
        this.setSpeed(JsonUtils.func_151221_a((JsonObject)object, (String)"speed", (float)1.5f));
        float damage = JsonUtils.func_151217_k((JsonObject)object, (String)"damage");
        this.setDamage(damage);
        if (JsonUtils.func_151204_g((JsonObject)object, (String)"effect")) {
            JsonObject effectObject = JsonUtils.func_152754_s((JsonObject)object, (String)"effect");
            EffectTypes type = EffectTypes.byName(JsonUtils.func_151200_h((JsonObject)effectObject, (String)"type"));
            switch (type) {
                case EXPLODE: {
                    float strength = JsonUtils.func_151217_k((JsonObject)effectObject, (String)"strength");
                    boolean causeFire = JsonUtils.func_151209_a((JsonObject)effectObject, (String)"cause_fire", (boolean)false);
                    this.setEffectType(EffectTypes.EXPLODE);
                    this.setEffect(new EffectExplode(strength, causeFire));
                    break;
                }
                case PUSHBACK: {
                    this.setEffectType(EffectTypes.PUSHBACK);
                    this.setEffect(null);
                    break;
                }
                case NONE: {
                    this.setEffectType(EffectTypes.NONE);
                    this.setEffect(null);
                }
            }
        } else {
            this.setEffectType(EffectTypes.NONE);
            this.setEffect(null);
        }
        this.setDebugMode(JsonUtils.func_151209_a((JsonObject)object, (String)"is_debug_mode_on", (boolean)false));
        return this;
    }

    public class EffectExplode
    extends Effect {
        private float strength;
        private boolean causeFire;

        EffectExplode(float strength, boolean causeFire) {
            this.strength = strength;
            this.causeFire = causeFire;
        }

        public float getStrength() {
            return this.strength;
        }

        public boolean causeFire() {
            return this.causeFire;
        }
    }

    class Effect {
        Effect() {
        }
    }

    public static enum EffectTypes implements IStringSerializable
    {
        EXPLODE,
        PUSHBACK,
        NONE;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public static EffectTypes byName(String name) {
            for (EffectTypes type : EffectTypes.values()) {
                if (!type.func_176610_l().equalsIgnoreCase(name)) continue;
                return type;
            }
            return NONE;
        }
    }
}

