/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.addonpacks.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import lucraft.mods.lucraftcore.addonpacks.AddonPackReadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FilenameUtils;
import spyeedy.mods.lcu.LCUMod;
import spyeedy.mods.lcu.addonpacks.model.JsonModelInfo;
import spyeedy.mods.lcu.client.model.ModelJSON;

@Mod.EventBusSubscriber
public class AddonPackModelReader {
    public static final LinkedHashMap<String, ModelJSON> MODELS = new LinkedHashMap();

    @SubscribeEvent
    public static void onRead(AddonPackReadEvent e) {
        if (e.getDirectory().equals("constructs") && e.getResourceLocation().func_110623_a().contains("models\\") && FilenameUtils.getExtension((String)e.getFileName()).equalsIgnoreCase("json")) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(e.getInputStream(), StandardCharsets.UTF_8));
                JsonObject jsonobject = new JsonParser().parse((Reader)reader).getAsJsonObject();
                JsonModelInfo info = new JsonModelInfo();
                info.deserialize(jsonobject);
                String id = e.getResourceLocation().func_110624_b() + ":" + info.name;
                if (!MODELS.containsKey(id)) {
                    MODELS.put(id, new ModelJSON(info));
                    LCUMod.LOGGER.info("Successfully loaded LCU model '" + id + "'");
                } else {
                    System.out.println("There's already another model with the name '" + id + "' registered! Change your model's name!");
                }
            }
            catch (Exception e2) {
                LCUMod.LOGGER.error("Wasn't able to read model '" + e.getFileName() + "' in addon pack '" + e.getPackFile().getName() + "': " + e2.getMessage());
            }
        }
    }
}

