/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.client.model;

import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import spyeedy.mods.lcu.addonpacks.model.JsonModelCube;
import spyeedy.mods.lcu.addonpacks.model.JsonModelInfo;

public class ModelJSON
extends ModelBase {
    private ArrayList<JsonModelCube> cubesList;
    private ModelRenderer[] cubes;
    private JsonModelInfo info;

    public ModelJSON(JsonModelInfo info) {
        this.field_78090_t = info.texture_size[0];
        this.field_78089_u = info.texture_size[1];
        this.info = info;
        this.cubesList = info.model_cubes;
        this.cubes = new ModelRenderer[this.cubesList.size()];
        for (JsonModelCube cube : this.cubesList) {
            if (cube == null) continue;
            int index = this.cubesList.indexOf(cube);
            this.cubes[index] = new ModelRenderer((ModelBase)this, cube.texture_offset[0], cube.texture_offset[1]);
            this.cubes[index].func_78790_a(cube.offset[0], cube.offset[1], cube.offset[2], cube.dimensions[0], cube.dimensions[1], cube.dimensions[2], cube.inflate);
            this.cubes[index].func_78793_a(cube.position[0], cube.position[1], cube.position[2]);
            this.cubes[index].field_78809_i = cube.mirror;
            if (cube.rotation_angles != null) {
                this.cubes[index].field_78795_f = (float)((double)cube.rotation_angles[0] * (Math.PI / 180));
                this.cubes[index].field_78796_g = (float)((double)cube.rotation_angles[1] * (Math.PI / 180));
                this.cubes[index].field_78808_h = (float)((double)cube.rotation_angles[2] * (Math.PI / 180));
            }
            if (cube.child_cubes.size() <= 0) continue;
            this.makeModelRenderer(cube, this.cubes[index]);
        }
    }

    public void render(float scale) {
        for (int cube = 0; cube < this.cubesList.size(); ++cube) {
            ModelRenderer modelCube = this.cubes[cube];
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)modelCube.field_82906_o, (float)modelCube.field_82908_p, (float)modelCube.field_82907_q);
            GlStateManager.func_179109_b((float)(modelCube.field_78800_c * scale), (float)(modelCube.field_78797_d * scale), (float)(modelCube.field_78798_e * scale));
            GlStateManager.func_179139_a((double)this.cubesList.get((int)cube).custom_scale[0], (double)this.cubesList.get((int)cube).custom_scale[1], (double)this.cubesList.get((int)cube).custom_scale[2]);
            GlStateManager.func_179109_b((float)(-modelCube.field_82906_o), (float)(-modelCube.field_82908_p), (float)(-modelCube.field_82907_q));
            GlStateManager.func_179109_b((float)(-modelCube.field_78800_c * scale), (float)(-modelCube.field_78797_d * scale), (float)(-modelCube.field_78798_e * scale));
            modelCube.func_78785_a(scale);
            GlStateManager.func_179121_F();
        }
    }

    public ResourceLocation getTexture() {
        if (!this.info.texture.equalsIgnoreCase("")) {
            return new ResourceLocation(this.info.texture);
        }
        return null;
    }

    public ResourceLocation getColorTexture() {
        return new ResourceLocation(this.info.color_texture);
    }

    private void makeModelRenderer(JsonModelCube parentInfo, ModelRenderer cuboid) {
        if (parentInfo.child_cubes.size() > 0) {
            for (JsonModelCube info : parentInfo.child_cubes) {
                ModelRenderer c = new ModelRenderer((ModelBase)this, info.texture_offset[0], info.texture_offset[1]);
                c.func_78790_a(info.offset[0], info.offset[1], info.offset[2], info.dimensions[0], info.dimensions[1], info.dimensions[2], info.inflate);
                c.func_78793_a(info.position[0], info.position[1], info.position[2]);
                c.field_78809_i = info.mirror;
                if (info.rotation_angles != null) {
                    c.field_78795_f = (float)((double)info.rotation_angles[0] * (Math.PI / 180));
                    c.field_78796_g = (float)((double)info.rotation_angles[1] * (Math.PI / 180));
                    c.field_78808_h = (float)((double)info.rotation_angles[2] * (Math.PI / 180));
                }
                this.makeModelRenderer(info, c);
                cuboid.func_78792_a(c);
            }
        }
    }
}

