/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.entity;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import spyeedy.mods.lcu.addonpacks.entity.AddonPackEntityReader;
import spyeedy.mods.lcu.addonpacks.entity.JsonProjectileInfo;

public class EntityProjectile
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    private String jsonEntityId;
    private Color color;

    public EntityProjectile(World worldIn) {
        super(worldIn);
    }

    public EntityProjectile(World worldIn, EntityLivingBase throwerIn, String entityId, Color color) {
        super(worldIn, throwerIn);
        this.jsonEntityId = entityId;
        this.color = color;
    }

    public void func_70030_z() {
        JsonProjectileInfo projectileInfo = this.getJsonInfo();
        if (projectileInfo != null) {
            this.func_70105_a(projectileInfo.getCollisionBox()[0], projectileInfo.getCollisionBox()[1]);
        }
        double speed = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72438_d(new Vec3d(this.field_70169_q, this.field_70167_r, this.field_70166_s));
        if (!(this.field_70170_p.field_72995_K || this.field_70173_aa <= 600 && !(speed < 0.01) || projectileInfo == null || projectileInfo.isDebugMode())) {
            this.func_70106_y();
        }
        super.func_70030_z();
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result == null || this.field_70128_L) {
            return;
        }
        if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
            JsonProjectileInfo projectileInfo;
            if (result.field_72308_g == this.field_70192_c) {
                return;
            }
            if (this.getJsonEntityId() != null && !this.getJsonEntityId().equals("") && (projectileInfo = this.getJsonInfo()) != null) {
                result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), projectileInfo.getDamage());
                if (projectileInfo.getEffectType() == JsonProjectileInfo.EffectTypes.EXPLODE) {
                    JsonProjectileInfo.EffectExplode effect = (JsonProjectileInfo.EffectExplode)projectileInfo.getEffect();
                    this.field_70170_p.func_72885_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, effect.getStrength(), effect.causeFire(), true);
                } else if (projectileInfo.getEffectType() == JsonProjectileInfo.EffectTypes.PUSHBACK) {
                    result.field_72308_g.func_70024_g(this.field_70159_w, 0.0, this.field_70179_y);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("entityId", this.jsonEntityId);
        compound.func_74768_a("colorR", this.color.getRed());
        compound.func_74768_a("colorG", this.color.getGreen());
        compound.func_74768_a("colorB", this.color.getBlue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.jsonEntityId = compound.func_74779_i("entityId");
        this.color = new Color(compound.func_74762_e("colorR"), compound.func_74762_e("colorG"), compound.func_74762_e("colorB"));
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70014_b(nbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_70037_a(ByteBufUtils.readTag((ByteBuf)additionalData));
    }

    public String getJsonEntityId() {
        return this.jsonEntityId;
    }

    public JsonProjectileInfo getJsonInfo() {
        return AddonPackEntityReader.PROJECTILES.get(this.jsonEntityId);
    }

    public Color getColor() {
        return this.color;
    }
}

