/*
 * Decompiled with CFR 0.152.
 */
package spyeedy.mods.lcu.entity;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.UUID;
import lucraft.mods.lucraftcore.extendedinventory.capabilities.CapabilityExtendedInventory;
import lucraft.mods.lucraftcore.extendedinventory.capabilities.IExtendedInventoryCapability;
import lucraft.mods.lucraftcore.karma.KarmaHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import spyeedy.mods.lcu.block.BlockPowerBattery;
import spyeedy.mods.lcu.item.ItemLanternRing;
import spyeedy.mods.lcu.superpowers.LCUSuperpowers;

public class EntityRing
extends EntityFlying
implements IEntityAdditionalSpawnData {
    private UUID targetUUID;
    private NonNullList<String> messages = NonNullList.func_191196_a();
    protected ItemLanternRing ring;
    protected BlockPowerBattery powerBattery;

    public EntityRing(World worldIn) {
        super(worldIn);
    }

    public EntityRing(World worldIn, UUID playerUUID, ItemLanternRing ring, BlockPowerBattery powerBattery, String[] messages) {
        this(worldIn);
        this.targetUUID = playerUUID;
        this.ring = ring;
        this.powerBattery = powerBattery;
        Collections.addAll(this.messages, messages);
        this.func_70105_a(0.25f, 0.25f);
    }

    public void func_70030_z() {
        super.func_70030_z();
        EntityPlayer player = this.field_70170_p.func_152378_a(this.targetUUID);
        boolean shouldRingbeAlive = false;
        if (player != null) {
            boolean ifHasRingForExtInv;
            ItemStack wristStack = ((IExtendedInventoryCapability)player.getCapability(CapabilityExtendedInventory.EXTENDED_INVENTORY_CAP, null)).getInventory().func_70301_a(2);
            boolean bl = ifHasRingForExtInv = !wristStack.func_190926_b() && wristStack.func_77973_b() == this.ring;
            if (player.func_110124_au().equals(this.getTargetUUID()) && !player.field_71071_by.func_70431_c(new ItemStack((Item)this.ring)) && !ifHasRingForExtInv && KarmaHandler.getKarma((EntityPlayer)player) >= LCUSuperpowers.GL_KARMA) {
                shouldRingbeAlive = true;
            }
            if (shouldRingbeAlive) {
                if (this.field_70173_aa == 1) {
                    for (String str : this.messages) {
                        player.func_145747_a((ITextComponent)new TextComponentString(str.replace("%pName", player.getDisplayNameString())));
                    }
                }
                double speed = 0.5;
                double distX = player.field_70165_t - this.field_70165_t;
                double distZ = player.field_70161_v - this.field_70161_v;
                double distY = this.field_70163_u - 1.5 - player.field_70163_u;
                if (distY < -1.0) {
                    this.field_70181_x += speed / 12.0;
                } else if (distY > 1.0) {
                    this.field_70181_x -= speed / 12.0;
                } else if (distY > -1.0 && distY < 1.0) {
                    this.field_70181_x = 0.0;
                }
                if (this.func_70032_d((Entity)player) > 3.0f) {
                    this.field_70159_w += distX / 40.0;
                    this.field_70179_y += distZ / 40.0;
                }
            }
        }
        if (!shouldRingbeAlive) {
            this.func_70106_y();
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        player.field_71071_by.func_70441_a(new ItemStack((Item)this.ring));
        ItemStack powerBatteryStack = new ItemStack(Item.func_150898_a((Block)this.powerBattery));
        if (!player.field_71071_by.func_70431_c(powerBatteryStack)) {
            player.field_71071_by.func_70441_a(powerBatteryStack);
        }
        return true;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("target_uuid", (NBTBase)NBTUtil.func_186862_a((UUID)this.targetUUID));
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.targetUUID = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("target_uuid"));
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70014_b(nbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_70037_a(ByteBufUtils.readTag((ByteBuf)additionalData));
    }

    public UUID getTargetUUID() {
        return this.targetUUID;
    }
}

